package com.biz.crm.dms.business.psi.product.local.repository.delivery;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.psi.product.local.entity.delivery.ProductDeliveryBill;
import com.biz.crm.dms.business.psi.product.local.mapper.delivery.ProductDeliveryBillMapper;
import com.biz.crm.dms.business.psi.product.sdk.dto.delivery.ProductDeliveryBillPaginationDto;
import com.biz.crm.dms.business.psi.product.sdk.vo.delivery.ProductDeliveryBillVo;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * <p>
 * 商品出库单表 服务实现类
 * </p>
 *
 * @author Bao Hongbin
 * @since 2022-01-15
 */
@Component
public class ProductDeliveryBillRepository extends ServiceImpl<ProductDeliveryBillMapper, ProductDeliveryBill> {

  /**
   * 分页查询
   *
   * @param pageable
   * @param paginationDto
   * @return
   */
  public Page<ProductDeliveryBillVo> findByConditions(Pageable pageable, ProductDeliveryBillPaginationDto paginationDto) {
    Page<ProductDeliveryBillVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.baseMapper.findByConditions(page, paginationDto, DelFlagStatusEnum.NORMAL);
  }

  /**
   * 根据单据id查询
   *
   * @param id
   * @param tenantCode
   * @return
   */
  public ProductDeliveryBill findDetailsById(String id, String tenantCode) {
    return this.lambdaQuery()
        .eq(ProductDeliveryBill::getTenantCode, tenantCode)
        .eq(ProductDeliveryBill::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .eq(ProductDeliveryBill::getEnableStatus, EnableStatusEnum.ENABLE.getCode())
        .eq(ProductDeliveryBill::getId, id)
        .one();
  }

  /**
   * 根据单据code查询
   *
   * @param code
   * @param tenantCode
   * @return
   */
  public ProductDeliveryBill findDetailsByCode(String code, String tenantCode) {
    return this.lambdaQuery()
            .eq(ProductDeliveryBill::getTenantCode, tenantCode)
            .eq(ProductDeliveryBill::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
            .eq(ProductDeliveryBill::getEnableStatus, EnableStatusEnum.ENABLE.getCode())
            .eq(ProductDeliveryBill::getDeliveryBillCode, code)
            .one();
  }

  /**
   * 根据ids查询单据
   *
   * @param ids
   * @return
   */
  public List<ProductDeliveryBill> findListByIds(List<String> ids) {
    return this.lambdaQuery()
        .in(ProductDeliveryBill::getId, ids)
        .list();
  }

  /**
   * 根据单据ids删除单据
   *
   * @param ids
   */
  public void deleteBatch(List<String> ids) {
    this.lambdaUpdate()
        .in(ProductDeliveryBill::getId, ids)
        .set(ProductDeliveryBill::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }
}
