package com.biz.crm.dms.business.psi.product.local.repository.productstock;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.psi.product.local.entity.productstock.ProductSecurityStockQuantity;
import com.biz.crm.dms.business.psi.product.local.mapper.productstock.ProductSecurityStockQuantityMapper;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * <p>
 * 商品安全库存数量表 服务实现类
 * </p>
 *
 * @author Bao Hongbin
 * @since 2022-01-07
 */
@Component
public class ProductSecurityStockQuantityRepository extends ServiceImpl<ProductSecurityStockQuantityMapper, ProductSecurityStockQuantity> {

  /**
   * 通过安全库存id查询数量详情
   *
   * @param id
   * @return
   */
  public List<ProductSecurityStockQuantity> findBySecurityStockId(String id) {
    return this.lambdaQuery().eq(ProductSecurityStockQuantity::getSecurityStockId, id).list();
  }
}
