package com.biz.crm.dms.business.psi.product.local.repository.productstock;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.psi.product.local.entity.productstock.ProductSecurityStockQuantityWarehouse;
import com.biz.crm.dms.business.psi.product.local.mapper.productstock.ProductSecurityStockQuantityWarehouseMapper;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * <p>
 * 商品安全库存数量适用仓库表 服务实现类
 * </p>
 *
 * @author Bao Hongbin
 * @since 2022-01-07
 */
@Component
public class ProductSecurityStockQuantityWarehouseRepository extends ServiceImpl<ProductSecurityStockQuantityWarehouseMapper, ProductSecurityStockQuantityWarehouse> {

  /**
   * 根据数量信息ids删除对应仓库信息
   *
   * @param quantityIds
   */
  public void deleteByQuantityIds(List<String> quantityIds) {
    this.lambdaUpdate().in(ProductSecurityStockQuantityWarehouse::getSecurityStockQuantityId, quantityIds).remove();
  }
}
