package com.biz.crm.dms.business.psi.product.local.repository.productstock;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.psi.product.local.entity.productstock.ProductSecurityStock;
import com.biz.crm.dms.business.psi.product.local.mapper.productstock.ProductSecurityStockMapper;
import com.biz.crm.dms.business.psi.product.sdk.dto.productstock.ProductSecurityStockConditionDto;
import com.biz.crm.dms.business.psi.product.sdk.dto.productstock.ProductSecurityStockPaginationDto;
import com.biz.crm.dms.business.psi.product.sdk.vo.productstock.ProductSecurityStockVo;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * <p>
 * 商品安全库存表 服务实现类
 * </p>
 *
 * @author Bao Hongbin
 * @since 2022-01-07
 */
@Component
public class ProductSecurityStockRepository extends ServiceImpl<ProductSecurityStockMapper, ProductSecurityStock> {

  /**
   * 分页查询
   *
   * @param pageable
   * @param paginationDto
   * @return
   */
  public Page<ProductSecurityStockVo> findByConditions(Pageable pageable, ProductSecurityStockPaginationDto paginationDto) {
    Page<ProductSecurityStockVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.baseMapper.findByConditions(page, paginationDto, DelFlagStatusEnum.NORMAL);
  }

  /**
   * 查询详情
   *
   * @param id
   * @param tenantCode
   * @return
   */
  public ProductSecurityStockVo findDetailsById(String id, String tenantCode) {
    return this.baseMapper.findDetailsById(id, tenantCode);
  }

  /**
   * 批量删除
   *
   * @param ids
   */
  public void deleteBatch(List<String> ids) {
    this.lambdaUpdate()
        .in(ProductSecurityStock::getId, ids)
        .set(ProductSecurityStock::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }

  public List<ProductSecurityStockVo> findDetailsByConditions(ProductSecurityStockConditionDto dto, String tenantCode) {
    return this.baseMapper.findDetailsByConditions(dto, tenantCode,DelFlagStatusEnum.NORMAL.getCode(),EnableStatusEnum.ENABLE.getCode());
  }
}
