package com.biz.crm.dms.business.psi.product.local.repository.store;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.psi.product.local.entity.store.ProductStoredBill;
import com.biz.crm.dms.business.psi.product.local.mapper.store.ProductStoredBillMapper;
import com.biz.crm.dms.business.psi.product.sdk.dto.store.ProductStoredBillPaginationDto;
import com.biz.crm.dms.business.psi.product.sdk.vo.delivery.ProductDeliveryBillVo;
import com.biz.crm.dms.business.psi.product.sdk.vo.store.ProductStoredBillVo;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * <p>
 * 商品入库单表 服务实现类
 * </p>
 *
 * @author Bao Hongbin
 * @since 2022-01-15
 */
@Component
public class ProductStoredBillRepository extends ServiceImpl<ProductStoredBillMapper, ProductStoredBill> {

  /**
   * 分页查询
   *
   * @param pageable
   * @param paginationDto
   * @return
   */
  public Page<ProductStoredBillVo> findByConditions(Pageable pageable, ProductStoredBillPaginationDto paginationDto) {
    Page<ProductDeliveryBillVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.baseMapper.findByConditions(page, paginationDto, DelFlagStatusEnum.NORMAL);
  }

  /**
   * 根据单据id查询
   *
   * @param id
   * @param tenantCode
   * @return
   */
  public ProductStoredBill findDetailsById(String id, String tenantCode) {
    return this.lambdaQuery()
        .eq(ProductStoredBill::getTenantCode, tenantCode)
        .eq(ProductStoredBill::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .eq(ProductStoredBill::getEnableStatus, EnableStatusEnum.ENABLE.getCode())
        .eq(ProductStoredBill::getId, id)
        .one();
  }

  /**
   * 根据单据code查询
   *
   * @param code
   * @param tenantCode
   * @return
   */
  public ProductStoredBill findDetailsByCode(String code, String tenantCode) {
    return this.lambdaQuery()
            .eq(ProductStoredBill::getTenantCode, tenantCode)
            .eq(ProductStoredBill::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
            .eq(ProductStoredBill::getEnableStatus, EnableStatusEnum.ENABLE.getCode())
            .eq(ProductStoredBill::getStoredBillCode, code)
            .one();
  }

  /**
   * 根据ids查询单据
   *
   * @param ids
   * @return
   */
  public List<ProductStoredBill> findListByIds(List<String> ids) {
    return this.lambdaQuery()
        .in(ProductStoredBill::getId, ids)
        .list();
  }

  /**
   * 根据单据ids删除单据
   *
   * @param ids
   */
  public void deleteBatch(List<String> ids) {
    this.lambdaUpdate()
        .in(ProductStoredBill::getId, ids)
        .set(ProductStoredBill::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }

  /**
   * 通过关联收货单编码查询信息
   * @param code
   * @return
   */
  public List<ProductStoredBill> findDetailsByReceivingCode(String code) {
    return this.lambdaQuery()
        .eq(ProductStoredBill::getRelationReceivingOrderCode,code)
        .eq(ProductStoredBill::getDelFlag,DelFlagStatusEnum.NORMAL.getCode())
        .list();

  }
}
