package com.biz.crm.dms.business.psi.product.local.service.productstock;

import com.biz.crm.dms.business.psi.product.local.entity.productstock.ProductStock;
import com.biz.crm.dms.business.psi.product.local.entity.productstock.ProductStockDetail;
import com.biz.crm.dms.business.psi.product.sdk.dto.productstock.ProductStockOperationDto;
import com.biz.crm.dms.business.psi.product.sdk.enums.productstock.ProductStockOperation;

import java.util.List;

/**
 * 商品库存明细服务
 * Created by Bao Hongbin on 2022-01-11 14:41.
 */
public interface ProductStockDetailService {

  /**
   * 通过订单编号查询指定库存操作的库存明细（如不指定库存操作，则查询全部）
   *
   * @param orderCode 库存明细关联的订单编号
   * @param operation 库存操作
   * @return 商品库存明细集合
   */
  List<ProductStockDetail> findListByOrderCode(String orderCode, ProductStockOperation operation);

  /**
   * 通过仓库编码更改仓库名称
   * @param warehouseCode
   * @param warehouseName
   */
  void updateWarehouseMsg(String warehouseCode, String warehouseName);
}
