package com.biz.crm.dms.business.psi.product.local.service.productstock;

import com.biz.crm.dms.business.psi.product.local.entity.productstock.ProductStock;
import com.biz.crm.dms.business.psi.product.sdk.dto.productstock.ProductStockOperationDto;

import java.util.List;
import java.util.Set;

/**
 * 商品库存服务
 * Created by Bao Hongbin on 2022-01-11 14:41.
 */
public interface ProductStockService {

  /**
   * 商品入库
   *
   * @param productStockOperationDto 库存操作dto
   * @return 商品库存
   */
  ProductStock store(ProductStockOperationDto productStockOperationDto);

  /**
   * 商品出库
   *
   * @param productStockOperationDto 库存操作dto
   * @return 商品库存
   */
  ProductStock deliver(ProductStockOperationDto productStockOperationDto);

  /**
   * 冻结
   *
   * @param productStockOperationDto 库存操作dto
   * @return 商品库存
   */
  ProductStock frozen(ProductStockOperationDto productStockOperationDto);

  /**
   * 解冻
   *
   * @param productStockOperationDto 库存操作dto
   * @return 商品库存
   */
  ProductStock thaw(ProductStockOperationDto productStockOperationDto);

  /**
   * 通过商品编码集合和库存类型查询
   * @param productCodes
   * @return
   */
  List<ProductStock> findByTypeAndProductCodeIn(List<String> productCodes, String type);

  /**
   * 根据仓库编码和商品编码集合查询库存
   * @param warehouseCode
   * @param productCodes
   * @return
   */
  List<ProductStock> findByWarehouseAndProducts(String warehouseCode, Set<String> productCodes);

  /**
   * 根据仓库编码查询库存
   * @param warehouseCode
   * @return
   */
  List<ProductStock> findByWarehouseCode (String warehouseCode);

  /**
   * 通过仓库编码更新仓库信息
   * @param warehouseCode
   * @param warehouseName
   */
  void updateWarehouseMsg(String warehouseCode, String warehouseName);
}
