package com.biz.crm.dms.business.psi.product.local.service.productstock.internal;

import com.biz.crm.dms.business.psi.product.local.repository.productstock.ProductStockDetailRepository;
import com.biz.crm.dms.business.psi.product.sdk.dto.productstock.DeliveryStockDto;
import com.biz.crm.dms.business.psi.product.sdk.dto.productstock.ProductStockDetailPaginationDto;
import com.biz.crm.dms.business.psi.product.sdk.service.productstock.DeliveryStockVoService;
import com.biz.crm.dms.business.psi.product.sdk.service.productstock.ProductStockVoService;
import com.biz.crm.dms.business.psi.product.sdk.vo.productstock.DeliveryStockVo;
import com.biz.crm.dms.business.psi.product.sdk.vo.productstock.ProductStockDetailVo;
import com.biz.crm.dms.business.psi.product.sdk.vo.productstock.ProductStockVo;
import com.biz.crm.mdm.business.warehouse.sdk.service.WarehouseVoService;
import com.biz.crm.mdm.business.warehouse.sdk.vo.WarehouseVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/**
 * @Author: zengxingwang
 * @Date: 2022/3/10 14:24
 */
@Service
public class DeliveryStockVoServiceImpl implements DeliveryStockVoService {

  @Autowired(required = false)
  private WarehouseVoService warehouseVoService;

  @Autowired(required = false)
  private ProductStockVoService productStockVoService;

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Autowired(required = false)
  private ProductStockDetailRepository productStockDetailRepository;

  /**
   * 发货单查询库存信息
   * @param list
   * @return
   */
  @Override
  public List<DeliveryStockVo> findByDeliveryStockDto(List<DeliveryStockDto> list) {
    this.validate(list);
    List<DeliveryStockVo> result = new ArrayList<>();
    for(DeliveryStockDto dto : list){
      List<ProductStockVo> productStockVos = new ArrayList<>();
      WarehouseVo warehouse = warehouseVoService.findDetailsByCityCode(dto.getCityCode());
      if(warehouse != null){
        List<ProductStockVo> productStocks = productStockVoService.findByWarehouseAndProducts(warehouse.getWarehouseCode(), dto.getProductCodes());
        if(CollectionUtils.isNotEmpty(productStocks)) {
          productStocks.stream().forEach(item -> item.setWarehouseDefault(true));
          productStockVos.addAll(productStocks);
        }
      }
      WarehouseVo defaultWarehouse = warehouseVoService.findDetailsByWarehouseDefault(true);
      if(defaultWarehouse != null){
        List<ProductStockVo> defaultProductStocks = productStockVoService.findByWarehouseAndProducts(defaultWarehouse.getWarehouseCode(), dto.getProductCodes());
        if(CollectionUtils.isNotEmpty(defaultProductStocks)) {
          defaultProductStocks.stream().forEach(item -> item.setWarehouseDefault(true));
          productStockVos.addAll(defaultProductStocks);
        }
      }

      List<DeliveryStockVo> deliveryStockVos = (List<DeliveryStockVo>) nebulaToolkitService.copyCollectionByWhiteList(productStockVos, ProductStockVo.class, DeliveryStockVo.class, HashSet.class, ArrayList.class);
      deliveryStockVos.stream().forEach(item -> item.setOrderCode(dto.getOrderCode()));
      result.addAll(deliveryStockVos);
    }

    return result;
  }

  @Override
  public List<DeliveryStockVo> findByDeliveryMaterialStockDto(List<DeliveryStockDto> list) {
    Validate.isTrue(CollectionUtils.isNotEmpty(list),"查询物料库存传入参数为空");
    List<DeliveryStockVo> result = new ArrayList<>();
    for (DeliveryStockDto deliveryStockDto : list) {
      Validate.isTrue(CollectionUtils.isNotEmpty(deliveryStockDto.getProductCodes()),"查询物料库存时，物料集合不能为空");
      Validate.notBlank(deliveryStockDto.getOrderCode(),"查询物料库存时，订单编码不能为空");
      Validate.notBlank(deliveryStockDto.getStockType(),"查询物料库存时，库存类型不能为空");
      List<String> productCodeList = new ArrayList<>();
      deliveryStockDto.getProductCodes().forEach(s -> {
        productCodeList.add(s);
      });
      List<ProductStockVo> defaultProductStocks = productStockVoService.findByTypeAndProductCodeIn(productCodeList,deliveryStockDto.getStockType());
      List<DeliveryStockVo> deliveryStockVos = (List<DeliveryStockVo>) nebulaToolkitService.copyCollectionByWhiteList(defaultProductStocks, ProductStockVo.class, DeliveryStockVo.class, HashSet.class, ArrayList.class);
      deliveryStockVos.stream().forEach(item -> item.setOrderCode(deliveryStockDto.getOrderCode()));
      result.addAll(deliveryStockVos);
    }
    return result;
  }

  /**
   * 根据订单编码和行查询库存信息
   * @param list
   * @return
   */
  @Override
  public List<DeliveryStockVo> findByOrderCodeAndItemCode(List<DeliveryStockDto> list) {
    if(CollectionUtils.isEmpty(list)){
      return null;
    }
    List<String> codes = new ArrayList<>();
    for(DeliveryStockDto deliveryStockDto : list){
      String code = deliveryStockDto.getOrderCode()+deliveryStockDto.getOrderItemCode();
      codes.add(code);
    }
    return productStockDetailRepository.findByOrderCodeAndItemCode(codes);
  }

  /**
   * 数据验证
   * @param list
   */
  private void validate(List<DeliveryStockDto> list) {
    Validate.notEmpty(list, "数据不能为空");
    for(DeliveryStockDto dto : list){
      Validate.notBlank(dto.getOrderCode(), "订单编码不能为空");
      Validate.notBlank(dto.getCityCode(), "城市编码不能为空");
      Validate.notEmpty(dto.getProductCodes(), "商品编码不能为空");
    }
  }
}
