package com.biz.crm.dms.business.psi.product.local.service.productstock.internal;
/**
 * Created by Bao Hongbin on 2022-01-19 11:03.
 */

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.psi.product.local.entity.productstock.ProductStock;
import com.biz.crm.dms.business.psi.product.local.entity.productstock.ProductStockDetail;
import com.biz.crm.dms.business.psi.product.local.repository.productstock.ProductStockDetailRepository;
import com.biz.crm.dms.business.psi.product.local.repository.productstock.ProductStockRepository;
import com.biz.crm.dms.business.psi.product.sdk.dto.productstock.ProductStockDetailPaginationDto;
import com.biz.crm.dms.business.psi.product.sdk.enums.productstock.StockType;
import com.biz.crm.dms.business.psi.product.sdk.service.productstock.ProductStockDetailVoService;
import com.biz.crm.dms.business.psi.product.sdk.vo.productstock.ProductStockDetailVo;
import com.biz.crm.mdm.business.material.sdk.service.MaterialVoService;
import com.biz.crm.mdm.business.material.sdk.vo.MaterialVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @program: crm-dms
 * @description: 商品库存详情vo服务实现
 * @author: Bao Hongbin
 * @create: 2022-01-19 11:03
 **/
@Service
public class ProductStockDetailVoServiceImpl implements ProductStockDetailVoService {
  @Autowired(required = false)
  private ProductStockDetailRepository productStockDetailRepository;
  @Autowired(required = false)
  private ProductStockRepository productStockRepository;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private ProductVoService productVoService;
  @Autowired(required = false)
  private MaterialVoService materialVoService;

  @Override
  public Page<ProductStockDetailVo> findFreezeStockDetailByConditions(Pageable pageable, ProductStockDetailPaginationDto paginationDto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
    paginationDto = Optional.ofNullable(paginationDto).orElse(new ProductStockDetailPaginationDto());
    paginationDto.setTenantCode(TenantUtils.getTenantCode());
    return this.productStockDetailRepository.findFreezeStockDetailByConditions(pageable, paginationDto);
  }

  @Override
  public Page<ProductStockDetailVo> findStockOperationDetailByConditions(Pageable pageable, ProductStockDetailPaginationDto paginationDto) {
    Validate.notNull(paginationDto,"传入数据不能为空");
    Validate.notNull(paginationDto.getStockId(),"查询库存明细时，传入库存id不能为空");
    ProductStock productStock = this.productStockRepository.getById(paginationDto.getStockId());
    Validate.notNull(productStock,"商品库存信息不存在！");
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
    paginationDto = Optional.ofNullable(paginationDto).orElse(new ProductStockDetailPaginationDto());
    paginationDto.setTenantCode(TenantUtils.getTenantCode());
    Page<ProductStockDetailVo> page = this.productStockDetailRepository.findStockOperationDetailByConditions(pageable, paginationDto);
    //这里没有保存单位提出疑问（还是建议冗余物料产品单位）
    if (CollectionUtils.isNotEmpty(page.getRecords())) {
      List<String> productCodes = page.getRecords().stream().map(ProductStockDetailVo::getProductCode).distinct().collect(Collectors.toList());
      Set<String>  materialCodes = page.getRecords().stream().map(ProductStockDetailVo::getProductCode).collect(Collectors.toSet());
      if(StockType.PRODUCT.getKey().equals(productStock.getType())) {
        Map<String, ProductVo> ProductVoMap = this.productVoService.findMainDetailsByProductCodes(productCodes)
            .stream().collect(
                Collectors.toMap(
                    ProductVo::getProductCode, Function.identity(), (o1, o2) -> o2));
        for (ProductStockDetailVo record : page.getRecords()) {
          ProductVo productVo = ProductVoMap.get(record.getProductCode());
          Validate.notNull(productVo, "无法获取的商品信息");
          record.setProductUnit(productVo.getSaleUnit());
        }
      }
      if(StockType.MATERIAL.getKey().equals(productStock.getType())) {
        Map<String, MaterialVo> materialVos = this.materialVoService.findDetailByMaterialCodes(materialCodes)
            .stream().collect(
                Collectors.toMap(
                    MaterialVo::getMaterialCode, Function.identity(), (o1, o2) -> o2));;
        for (ProductStockDetailVo record : page.getRecords()) {
          MaterialVo materialVo = materialVos.get(record.getProductCode());
          Validate.notNull(materialVo, "无法获取的商品信息");
          record.setProductUnit(materialVo.getStandardUnit());
        }
      }
    }


    return page;
  }

  /**
   * 根据订单编码和行编码查询冻结信息
   * @param orderCode
   * @param orderItemCode
   * @return
   */
  @Override
  public List<ProductStockDetailVo> findFreezeStockDetailByOrderCodeAndOrderItemCode(String orderCode, String orderItemCode) {
    if(StringUtils.isBlank(orderCode) || StringUtils.isBlank(orderItemCode)){
      return Lists.newArrayList();
    }
    List<ProductStockDetail> freezes = productStockDetailRepository.findFreezeStockDetailByOrderCodeAndOrderItemCode(orderCode, orderItemCode);
    Collection<ProductStockDetailVo> productStockDetailVos = nebulaToolkitService.copyCollectionByWhiteList(freezes, ProductStockDetail.class, ProductStockDetailVo.class, HashSet.class, ArrayList.class);
    return Lists.newArrayList(productStockDetailVos);
  }
}
