package com.biz.crm.dms.business.psi.product.local.service.productstock.notifier;

import com.biz.crm.dms.business.psi.product.local.entity.productstock.ProductStock;
import com.biz.crm.dms.business.psi.product.local.repository.productstock.ProductStockRepository;
import com.biz.crm.dms.business.psi.product.local.service.productstock.ProductStockDetailService;
import com.biz.crm.dms.business.psi.product.local.service.productstock.ProductStockService;
import com.biz.crm.mdm.business.warehouse.sdk.event.WarehouseEventListener;
import com.biz.crm.mdm.business.warehouse.sdk.vo.WarehouseEventVo;
import com.biz.crm.mdm.business.warehouse.sdk.vo.WarehouseVo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 仓库事件实现
 *
 * @Author: zengxingwang
 * @Date: 2022/4/21 17:55
 */
@Component
public class WarehouseEventListenerImpl implements WarehouseEventListener {

  @Autowired(required = false)
  private ProductStockRepository productStockRepository;
  @Autowired
  private ProductStockService productStockService;
  @Autowired
  private ProductStockDetailService productStockDetailService;

  @Override
  public void onCreate(WarehouseEventVo vo) {
    //暂不实现
  }

  @Override
  @Transactional
  public void onUpdate(WarehouseEventVo vo) {
    WarehouseVo oldWarehouse = vo.getOldWarehouse();
    WarehouseVo newWarehouse = vo.getNewWarehouse();
    String warehouseCode = oldWarehouse.getWarehouseCode();
    String warehouseName = newWarehouse.getWarehouseName();
    //通过仓库编码更新主表仓库名称
    productStockService.updateWarehouseMsg(warehouseCode,warehouseName);
    //通过仓库编码更新子表仓库名称
    productStockDetailService.updateWarehouseMsg(warehouseCode,warehouseName);
  }

  @Override
  public void onDisable(WarehouseEventVo vo) {
    //暂不实现
  }

  @Override
  public void onEnable(WarehouseEventVo vo) {
    //暂不实现
  }

  @Override
  public void onDelete(WarehouseEventVo vo) {
    Validate.notNull(vo, "调用删除仓库事件时，参数不能为空");
    Validate.notEmpty(vo.getWarehouseVoList(), "调用删除仓库事件时，仓库数据不能为空");
    List<WarehouseVo> warehouseVoList = vo.getWarehouseVoList();
    List<String> warehouseCode = warehouseVoList.stream().map(WarehouseVo::getWarehouseCode).collect(Collectors.toList());
    List<ProductStock> list = productStockRepository.findByWarehouseCodes(warehouseCode);
    Validate.isTrue(CollectionUtils.isEmpty(list), "仓库已被使用请勿删除");
  }
}
