package com.biz.crm.dms.business.psi.product.local.service.store.internal;

import com.biz.crm.dms.business.psi.product.local.entity.store.ProductStoredBill;
import com.biz.crm.dms.business.psi.product.local.repository.store.ProductStoredBillDetailRepository;
import com.biz.crm.dms.business.psi.product.local.repository.store.ProductStoredBillRepository;
import com.biz.crm.dms.business.psi.product.local.service.store.ProductStoredBillVoService;
import com.biz.crm.dms.business.psi.product.sdk.service.store.StoredBillVoService;
import com.biz.crm.dms.business.psi.product.sdk.vo.store.ProductStoredBillVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * @author HanJiaJun
 * @describe:
 * @createTime 2022年07月04日 16:33:00
 */
@Service
@Slf4j
public class StoredBillVoServiceImpl  implements StoredBillVoService {

  @Autowired
  private ProductStoredBillRepository productStoredBillRepository;
  @Autowired
  private ProductStoredBillVoService productStoredBillVoService;

  /**
   * 通过关联收货单编码查询信息
   * @param code
   * @return
   */
  @Override
  public List<ProductStoredBillVo> findDetailsByReceivingCode(String code) {
    if (StringUtils.isBlank(code)){
      return new ArrayList<>(0);
    }
    List<ProductStoredBillVo> detailsByReceivingCode = productStoredBillVoService.findDetailsByReceivingCode(code);
    return  detailsByReceivingCode;
  }
}
