/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.psi.product.local.register.delivery.internal;

import com.biz.crm.dms.business.psi.product.local.entity.productstock.ProductStock;
import com.biz.crm.dms.business.psi.product.local.entity.productstock.ProductStockDetail;
import com.biz.crm.dms.business.psi.product.local.service.productstock.ProductStockDetailService;
import com.biz.crm.dms.business.psi.product.local.service.productstock.ProductStockService;
import com.biz.crm.dms.business.psi.product.sdk.dto.productstock.DeliveryProductStockOperationDto;
import com.biz.crm.dms.business.psi.product.sdk.dto.productstock.ProductStockOperationDto;
import com.biz.crm.dms.business.psi.product.sdk.enums.productstock.ProductStockOperation;
import com.biz.crm.dms.business.psi.product.sdk.register.delivery.DeliveryBillProductStockRegister;
import com.biz.crm.dms.business.psi.product.sdk.vo.productstock.ProductStockVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="SaleDeliverMaterialStockRegister")
public class SaleDeliverMaterialStockRegister
implements DeliveryBillProductStockRegister {
    private final String OPERATION_TYPE = "MATERIAL_ORDER_DELIVER";
    private final String VOID_OPERATION_TYPE = "VOID_MATERIAL_ORDER_DELIVER";
    @Autowired(required=false)
    private ProductStockService productStockService;
    @Autowired(required=false)
    private ProductStockDetailService productStockDetailService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private RedisMutexService redisMutexService;

    public String getOperationType() {
        return "MATERIAL_ORDER_DELIVER";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public ProductStockVo execute(DeliveryProductStockOperationDto operationDto) {
        Validate.notNull((Object)operationDto.getWarehouseCode(), (String)"\u53d8\u66f4\u5e93\u5b58\u7269\u6599\u6570\u91cf\u65f6\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)operationDto.getProductCode(), (String)"\u53d8\u66f4\u5e93\u5b58\u7269\u6599\u6570\u91cf\u65f6\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)operationDto.getQuantity(), (String)"\u53d8\u66f4\u5e93\u5b58\u7269\u6599\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)operationDto.getOrderCode(), (String)"\u9500\u552e\u8ba2\u5355\u51fa\u5e93\u6216\u4f5c\u5e9f\u65f6\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)operationDto.getOrderType(), (String)"\u9500\u552e\u8ba2\u5355\u51fa\u5e93\u6216\u4f5c\u5e9f\u65f6\u8ba2\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ProductStockOperationDto productStockOperationDto = (ProductStockOperationDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)operationDto, ProductStockOperationDto.class, HashSet.class, ArrayList.class, new String[0]);
        String s = String.format("PRODUCT_STOCK_LOCK:%s:%s", productStockOperationDto.getWarehouseCode(), productStockOperationDto.getProductCode());
        Validate.isTrue((boolean)this.redisMutexService.tryLock(s, TimeUnit.MILLISECONDS, 5000), (String)"\u5b58\u5728\u8fdb\u884c\u4e2d\u5173\u8054\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u518d\u8bd5!", (Object[])new Object[0]);
        try {
            ProductStockVo productStockVo;
            productStockOperationDto.setProductStockOperationType("MATERIAL_ORDER_DELIVER");
            List<ProductStockDetail> frozenDetails = this.productStockDetailService.findListByOrderCode(operationDto.getOrderCode(), ProductStockOperation.FROZEN);
            if (CollectionUtils.isNotEmpty(frozenDetails)) {
                this.productStockService.thaw(productStockOperationDto);
            }
            ProductStock productStock = this.productStockService.deliver(productStockOperationDto);
            ProductStockVo productStockVo2 = productStockVo = (ProductStockVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)productStock, ProductStockVo.class, HashSet.class, ArrayList.class, new String[0]);
            return productStockVo2;
        }
        finally {
            this.redisMutexService.unlock(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public ProductStockVo rescind(DeliveryProductStockOperationDto operationDto) {
        Validate.notNull((Object)operationDto.getWarehouseCode(), (String)"\u53d8\u66f4\u5e93\u5b58\u7269\u6599\u6570\u91cf\u65f6\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)operationDto.getProductCode(), (String)"\u53d8\u66f4\u5e93\u5b58\u7269\u6599\u6570\u91cf\u65f6\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)operationDto.getQuantity(), (String)"\u53d8\u66f4\u5e93\u5b58\u7269\u6599\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)operationDto.getOrderCode(), (String)"\u9500\u552e\u8ba2\u5355\u51fa\u5e93\u6216\u4f5c\u5e9f\u65f6\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)operationDto.getOrderType(), (String)"\u9500\u552e\u8ba2\u5355\u51fa\u5e93\u6216\u4f5c\u5e9f\u65f6\u8ba2\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ProductStockOperationDto productStockOperationDto = (ProductStockOperationDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)operationDto, ProductStockOperationDto.class, HashSet.class, ArrayList.class, new String[0]);
        Object transactionStatus = null;
        String s = String.format("PRODUCT_STOCK_LOCK:%s:%s", productStockOperationDto.getWarehouseCode(), productStockOperationDto.getProductCode());
        Validate.isTrue((boolean)this.redisMutexService.tryLock(s, TimeUnit.MILLISECONDS, 5000), (String)"\u5b58\u5728\u8fdb\u884c\u4e2d\u5173\u8054\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u518d\u8bd5!", (Object[])new Object[0]);
        try {
            ProductStockVo productStockVo;
            productStockOperationDto.setProductStockOperationType("VOID_MATERIAL_ORDER_DELIVER");
            ProductStock productStock = this.productStockService.store(productStockOperationDto);
            List<ProductStockDetail> frozenDetails = this.productStockDetailService.findListByOrderCode(operationDto.getOrderCode(), ProductStockOperation.FROZEN);
            if (CollectionUtils.isNotEmpty(frozenDetails)) {
                productStock = this.productStockService.frozen(productStockOperationDto);
            }
            ProductStockVo productStockVo2 = productStockVo = (ProductStockVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)productStock, ProductStockVo.class, HashSet.class, ArrayList.class, new String[0]);
            return productStockVo2;
        }
        finally {
            this.redisMutexService.unlock(s);
        }
    }
}

