/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.psi.product.local.repository.productstock;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.dms.business.psi.product.local.entity.productstock.ProductStockDetail;
import com.biz.crm.dms.business.psi.product.local.mapper.productstock.ProductStockDetailMapper;
import com.biz.crm.dms.business.psi.product.sdk.dto.productstock.ProductStockDetailPaginationDto;
import com.biz.crm.dms.business.psi.product.sdk.enums.productstock.ProductStockOperation;
import com.biz.crm.dms.business.psi.product.sdk.vo.productstock.DeliveryStockVo;
import com.biz.crm.dms.business.psi.product.sdk.vo.productstock.ProductStockDetailVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class ProductStockDetailRepository
extends ServiceImpl<ProductStockDetailMapper, ProductStockDetail> {
    public List<ProductStockDetail> findListByOrderCode(String orderCode, ProductStockOperation operation, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).eq(ProductStockDetail::getOrderCode, (Object)orderCode)).eq(operation != null, ProductStockDetail::getProductStockOperation, (Object)operation)).list();
    }

    public Page<ProductStockDetailVo> findFreezeStockDetailByConditions(Pageable pageable, ProductStockDetailPaginationDto paginationDto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return ((ProductStockDetailMapper)this.baseMapper).findFreezeStockDetailByConditions((Page<ProductStockDetailVo>)page, paginationDto, DelFlagStatusEnum.NORMAL);
    }

    public Page<ProductStockDetailVo> findStockOperationDetailByConditions(Pageable pageable, ProductStockDetailPaginationDto paginationDto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return ((ProductStockDetailMapper)this.baseMapper).findStockOperationDetailByConditions((Page<ProductStockDetailVo>)page, paginationDto, DelFlagStatusEnum.NORMAL);
    }

    public List<ProductStockDetail> findFreezeStockDetailByOrderCodeAndOrderItemCode(String orderCode, String orderItemCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(ProductStockDetail::getOrderCode, (Object)orderCode)).eq(ProductStockDetail::getOrderItemCode, (Object)orderItemCode)).eq(ProductStockDetail::getProductStockOperation, (Object)ProductStockOperation.FROZEN)).list();
    }

    public List<DeliveryStockVo> findByOrderCodeAndItemCode(List<String> list) {
        return ((ProductStockDetailMapper)this.baseMapper).findByOrderCodeAndItemCode(list);
    }

    public List<ProductStockDetail> findByWareAndProductAndOperationIn(String storeWarehouseCode, String productCode, List<ProductStockOperation> operations) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(ProductStockDetail::getWarehouseCode, (Object)storeWarehouseCode)).eq(ProductStockDetail::getProductCode, (Object)productCode)).in(ProductStockDetail::getProductStockOperation, operations)).list();
    }

    public void updateWarehouseMsg(String warehouseCode, String warehouseName) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(ProductStockDetail::getWarehouseCode, (Object)warehouseCode)).set(ProductStockDetail::getWarehouseName, (Object)warehouseName)).update();
    }
}

