/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.psi.product.local.repository.productstock;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.psi.product.local.entity.productstock.ProductStock;
import com.biz.crm.dms.business.psi.product.local.mapper.productstock.ProductStockMapper;
import com.biz.crm.dms.business.psi.product.sdk.dto.productstock.ProductStockPaginationDto;
import com.biz.crm.dms.business.psi.product.sdk.vo.productstock.ProductStockVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import java.util.Set;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ProductStockRepository
extends ServiceImpl<ProductStockMapper, ProductStock> {
    public ProductStock findByWarehouseCodeAndProductCode(String warehouseCode, String productCode, String tenantCode) {
        return (ProductStock)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(ProductStock::getWarehouseCode, (Object)warehouseCode)).eq(ProductStock::getProductCode, (Object)productCode)).one());
    }

    public Page<ProductStockVo> findByConditions(Pageable pageable, ProductStockPaginationDto paginationDto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return ((ProductStockMapper)this.baseMapper).findByConditions((Page<ProductStockVo>)page, paginationDto, DelFlagStatusEnum.NORMAL);
    }

    public List<ProductStock> findByTypeAndProductCodeIn(List<String> productCodes, String type) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(ProductStock::getType, (Object)type)).in(ProductStock::getProductCode, productCodes)).list();
    }

    public List<ProductStock> findByWarehouseAndProducts(String warehouseCode, Set<String> productCodes) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(ProductStock::getWarehouseCode, (Object)warehouseCode)).in(ProductStock::getProductCode, productCodes)).list();
    }

    public List<ProductStockVo> findByProductCodes(List<String> productCodes) {
        return ((ProductStockMapper)this.baseMapper).findByProductCodes(productCodes, DelFlagStatusEnum.NORMAL);
    }

    public List<ProductStock> findByWarehouseCodes(List<String> warehouseCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(ProductStock::getWarehouseCode, warehouseCode)).list();
    }

    public List<ProductStock> findByMaterialCode(List<String> materialCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(ProductStock::getProductCode, materialCode)).list();
    }

    public void updateEnableStatusByMaterialCode(EnableStatusEnum enable, List<String> materialCode) {
        if (CollectionUtils.isEmpty(materialCode)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(UuidFlagOpEntity::getEnableStatus, (Object)enable.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(ProductStock::getProductCode, materialCode)).update();
    }

    public List<ProductStock> findByWarehouseCode(String warehouseCode) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(ProductStock::getWarehouseCode, (Object)warehouseCode)).list();
    }

    public void updateWarehouseMsg(String warehouseCode, String warehouseName) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(ProductStock::getWarehouseCode, (Object)warehouseCode)).set(ProductStock::getWarehouseName, (Object)warehouseName)).update();
    }
}

