/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.psi.product.local.service.delivery.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.dms.business.psi.product.local.entity.delivery.ProductDeliveryBill;
import com.biz.crm.dms.business.psi.product.local.entity.delivery.ProductDeliveryBillDetail;
import com.biz.crm.dms.business.psi.product.local.repository.delivery.ProductDeliveryBillDetailRepository;
import com.biz.crm.dms.business.psi.product.local.repository.delivery.ProductDeliveryBillRepository;
import com.biz.crm.dms.business.psi.product.sdk.context.delivery.DeliveryBillProductStockContext;
import com.biz.crm.dms.business.psi.product.sdk.dto.delivery.ProductDeliveryBillCreateDto;
import com.biz.crm.dms.business.psi.product.sdk.dto.delivery.ProductDeliveryBillDetailDto;
import com.biz.crm.dms.business.psi.product.sdk.dto.delivery.ProductDeliveryBillPaginationDto;
import com.biz.crm.dms.business.psi.product.sdk.dto.delivery.ProductDeliveryBillUpdateDto;
import com.biz.crm.dms.business.psi.product.sdk.dto.productstock.DeliveryProductStockOperationDto;
import com.biz.crm.dms.business.psi.product.sdk.enums.delivery.ProductDeliveryStatus;
import com.biz.crm.dms.business.psi.product.sdk.enums.productstock.ProductStockBillType;
import com.biz.crm.dms.business.psi.product.sdk.enums.productstock.ProductStockOperationType;
import com.biz.crm.dms.business.psi.product.sdk.event.ProductDeliveryListener;
import com.biz.crm.dms.business.psi.product.sdk.register.delivery.DeliveryBillProductStockRegister;
import com.biz.crm.dms.business.psi.product.sdk.service.productstock.ProductDeliveryBillVoService;
import com.biz.crm.dms.business.psi.product.sdk.vo.delivery.ProductDeliveryBillDetailVo;
import com.biz.crm.dms.business.psi.product.sdk.vo.delivery.ProductDeliveryBillVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProductDeliveryBillVoServiceImpl
implements ProductDeliveryBillVoService {
    @Autowired(required=false)
    private ProductDeliveryBillRepository productDeliveryBillRepository;
    @Autowired(required=false)
    private ProductDeliveryBillDetailRepository productDeliveryBillDetailRepository;
    @Autowired(required=false)
    private GenerateCodeService generateCode;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private DeliveryBillProductStockContext deliveryBillProductStockContext;
    @Autowired(required=false)
    private List<ProductDeliveryListener> productDeliveryListeners;

    public Page<ProductDeliveryBillVo> findByConditions(Pageable pageable, ProductDeliveryBillPaginationDto paginationDto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        paginationDto = Optional.ofNullable(paginationDto).orElse(new ProductDeliveryBillPaginationDto());
        paginationDto.setTenantCode(TenantUtils.getTenantCode());
        return this.productDeliveryBillRepository.findByConditions(pageable, paginationDto);
    }

    public ProductDeliveryBillVo findDetailsById(String id) {
        if (!StringUtils.isNotEmpty((CharSequence)id)) {
            return null;
        }
        ProductDeliveryBill bill = this.productDeliveryBillRepository.findDetailsById(id, TenantUtils.getTenantCode());
        if (Objects.isNull((Object)bill)) {
            return null;
        }
        ProductDeliveryBillVo billVo = (ProductDeliveryBillVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)bill, ProductDeliveryBillVo.class, HashSet.class, ArrayList.class, new String[0]);
        List detailVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(this.productDeliveryBillDetailRepository.findListByBillId(bill.getId()), ProductDeliveryBillDetail.class, ProductDeliveryBillDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
        billVo.setDetailVos(detailVos);
        return billVo;
    }

    public ProductDeliveryBillVo findDetailsByCode(String code) {
        if (!StringUtils.isNotEmpty((CharSequence)code)) {
            return null;
        }
        ProductDeliveryBill bill = this.productDeliveryBillRepository.findDetailsByCode(code, TenantUtils.getTenantCode());
        if (Objects.isNull((Object)bill)) {
            return null;
        }
        ProductDeliveryBillVo billVo = (ProductDeliveryBillVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)bill, ProductDeliveryBillVo.class, HashSet.class, ArrayList.class, new String[0]);
        List detailVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(this.productDeliveryBillDetailRepository.findListByBillId(bill.getId()), ProductDeliveryBillDetail.class, ProductDeliveryBillDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
        billVo.setDetailVos(detailVos);
        return billVo;
    }

    @Transactional
    public ProductDeliveryBillVo create(ProductDeliveryBillCreateDto createDto) {
        return this.createForm(createDto);
    }

    private ProductDeliveryBillVo createForm(ProductDeliveryBillCreateDto createDto) {
        this.validateCreate(createDto);
        ProductDeliveryBill bill = (ProductDeliveryBill)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)createDto, ProductDeliveryBill.class, HashSet.class, ArrayList.class, new String[0]));
        bill.setTenantCode(TenantUtils.getTenantCode());
        bill.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        bill.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        bill.setDeliveryBillCode((String)this.generateCode.generateCode("SPCK", 1).get(0));
        bill.setDeliveryStatus(ProductDeliveryStatus.WAIT_DELIVERY);
        this.productDeliveryBillRepository.save((Object)bill);
        ProductDeliveryBillVo billVo = (ProductDeliveryBillVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)bill, ProductDeliveryBillVo.class, HashSet.class, ArrayList.class, new String[0]);
        List<ProductDeliveryBillDetailVo> detailVos = this.saveDetails(bill, createDto.getDetailDtos());
        billVo.setDetailVos(detailVos);
        this.handleDeliveryBatch(Lists.newArrayList((Object[])new String[]{bill.getId()}));
        if (CollectionUtils.isNotEmpty(this.productDeliveryListeners)) {
            this.productDeliveryListeners.forEach(listener -> listener.onCreate(billVo));
        }
        return billVo;
    }

    private void validateCreate(ProductDeliveryBillCreateDto createDto) {
        Validate.notNull((Object)createDto.getDeliveryTime(), (String)"\u51fa\u5e93\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)createDto.getProductStockOperationType(), (String)"\u5546\u54c1\u5e93\u5b58\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (ProductStockOperationType.SALE_DELIVER.equals((Object)createDto.getProductStockOperationType())) {
            Validate.notBlank((CharSequence)createDto.getRelationShipmentOrderCode(), (String)"\u5173\u8054\u53d1\u8d27\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)createDto.getRelationShipmentOrderType(), (String)"\u5173\u8054\u53d1\u8d27\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        Validate.notBlank((CharSequence)createDto.getDeliveryWarehouseCode(), (String)"\u51fa\u5e93\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)createDto.getDeliveryWarehouseName(), (String)"\u51fa\u5e93\u4ed3\u5e93\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((Collection)createDto.getDetailDtos(), (String)"\u5546\u54c1\u51fa\u5e93\u5355\u5546\u54c1\u884c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    @Transactional
    public ProductDeliveryBillVo update(ProductDeliveryBillUpdateDto updateDto) {
        return this.updateForm(updateDto);
    }

    private ProductDeliveryBillVo updateForm(ProductDeliveryBillUpdateDto updateDto) {
        this.validateUpdate(updateDto);
        ProductDeliveryBill bill = (ProductDeliveryBill)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)updateDto, ProductDeliveryBill.class, HashSet.class, ArrayList.class, new String[0]));
        bill.setDeliveryStatus(ProductDeliveryStatus.WAIT_DELIVERY);
        this.productDeliveryBillRepository.updateById((Object)bill);
        ProductDeliveryBillVo billVo = (ProductDeliveryBillVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)bill, ProductDeliveryBillVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.productDeliveryBillDetailRepository.deleteByBillId(bill.getId());
        List<ProductDeliveryBillDetailVo> detailVos = this.saveDetails(bill, updateDto.getDetailDtos());
        billVo.setDetailVos(detailVos);
        return billVo;
    }

    private List<ProductDeliveryBillDetailVo> saveDetails(ProductDeliveryBill bill, List<ProductDeliveryBillDetailDto> detailDtos) {
        String productStockOperationType = bill.getProductStockOperationType();
        if (ProductStockOperationType.OTHER_DELIVER.toString().equals(productStockOperationType) || ProductStockOperationType.MATERIAL_OTHER_DELIVER.toString().equals(productStockOperationType)) {
            for (ProductDeliveryBillDetailDto dto : detailDtos) {
                Validate.notNull((Object)dto.getCurrentQuantity(), (String)"\u672c\u6b21\u51fa\u5e93\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notNull((Object)dto.getAvailableStock(), (String)"\u53ef\u7528\u5e93\u5b58\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.isTrue((dto.getCurrentQuantity().compareTo(dto.getAvailableStock()) <= 0 ? 1 : 0) != 0, (String)("\u5546\u54c1" + dto.getProductCode() + "\u672c\u6b21\u51fa\u5e93\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u53ef\u7528\u5e93\u5b58\u6570\u91cf"), (Object[])new Object[0]);
            }
        } else {
            for (ProductDeliveryBillDetailDto dto : detailDtos) {
                Validate.notNull((Object)dto.getDeliveryingQuantity(), (String)"\u5f85\u51fa\u5e93\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notNull((Object)dto.getCurrentQuantity(), (String)"\u672c\u6b21\u51fa\u5e93\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.isTrue((dto.getCurrentQuantity().compareTo(dto.getDeliveryingQuantity()) <= 0 ? 1 : 0) != 0, (String)("\u5546\u54c1" + dto.getProductCode() + "\u672c\u6b21\u51fa\u5e93\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u5f85\u51fa\u5e93\u6570\u91cf"), (Object[])new Object[0]);
            }
        }
        List billDetails = (List)this.nebulaToolkitService.copyCollectionByWhiteList(detailDtos, ProductDeliveryBillDetailDto.class, ProductDeliveryBillDetail.class, HashSet.class, ArrayList.class, new String[0]);
        for (ProductDeliveryBillDetail billDetail : billDetails) {
            billDetail.setTenantCode(TenantUtils.getTenantCode());
            billDetail.setDeliveryBillId(bill.getId());
            billDetail.setDeliveryBillCode(bill.getDeliveryBillCode());
            if (!Objects.isNull(billDetail.getDeliveryOutQuantity())) continue;
            billDetail.setDeliveryOutQuantity(BigDecimal.ZERO);
        }
        this.productDeliveryBillDetailRepository.saveBatch(billDetails);
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)billDetails, ProductDeliveryBillDetail.class, ProductDeliveryBillDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    private void validateUpdate(ProductDeliveryBillUpdateDto updateDto) {
        Validate.notBlank((CharSequence)updateDto.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)updateDto.getDeliveryBillCode(), (String)"\u51fa\u5e93\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)updateDto.getDeliveryTime(), (String)"\u51fa\u5e93\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)updateDto.getProductStockOperationType(), (String)"\u5546\u54c1\u5e93\u5b58\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (ProductStockOperationType.SALE_DELIVER.equals((Object)updateDto.getProductStockOperationType())) {
            Validate.notBlank((CharSequence)updateDto.getRelationShipmentOrderCode(), (String)"\u5173\u8054\u53d1\u8d27\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)updateDto.getRelationShipmentOrderType(), (String)"\u5173\u8054\u53d1\u8d27\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        Validate.notBlank((CharSequence)updateDto.getDeliveryWarehouseCode(), (String)"\u51fa\u5e93\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)updateDto.getDeliveryWarehouseName(), (String)"\u51fa\u5e93\u4ed3\u5e93\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((Collection)updateDto.getDetailDtos(), (String)"\u5546\u54c1\u51fa\u5e93\u5355\u5546\u54c1\u884c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ProductDeliveryBill bill = this.productDeliveryBillRepository.findDetailsById(updateDto.getId(), TenantUtils.getTenantCode());
        Validate.isTrue((boolean)Objects.nonNull((Object)bill), (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u51fa\u5e93\u5355", (Object[])new Object[0]);
        ProductDeliveryStatus status = bill.getDeliveryStatus();
        Validate.isTrue((ProductDeliveryStatus.WAIT_DELIVERY.equals((Object)status) || ProductDeliveryStatus.REJECTED.equals((Object)status) ? 1 : 0) != 0, (String)"\u53ea\u6709\u5f85\u51fa\u5e93\u548c\u5df2\u9a73\u56de\u7684\u51fa\u5e93\u5355\u624d\u5141\u8bb8\u7f16\u8f91", (Object[])new Object[0]);
    }

    @Transactional
    public void deleteBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        List<ProductDeliveryBill> bills = this.productDeliveryBillRepository.findListByIds(ids);
        if (CollectionUtils.isEmpty(bills)) {
            return;
        }
        for (ProductDeliveryBill bill : bills) {
            ProductDeliveryStatus status = bill.getDeliveryStatus();
            Validate.isTrue((ProductDeliveryStatus.WAIT_DELIVERY.equals((Object)status) || ProductDeliveryStatus.REJECTED.equals((Object)status) || ProductDeliveryStatus.VOIDED.equals((Object)status) ? 1 : 0) != 0, (String)"\u53ea\u6709\u5f85\u51fa\u5e93\u3001\u5df2\u4f5c\u5e9f\u548c\u5df2\u9a73\u56de\u7684\u51fa\u5e93\u5355\u624d\u5141\u8bb8\u5220\u9664", (Object[])new Object[0]);
        }
        this.productDeliveryBillRepository.deleteBatch(ids);
    }

    @Transactional
    public void handleDeliveryBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        List<ProductDeliveryBill> bills = this.productDeliveryBillRepository.findListByIds(ids);
        if (CollectionUtils.isEmpty(bills)) {
            return;
        }
        for (ProductDeliveryBill bill : bills) {
            ProductDeliveryStatus status = bill.getDeliveryStatus();
            Validate.isTrue((boolean)ProductDeliveryStatus.WAIT_DELIVERY.equals((Object)status), (String)"\u53ea\u6709\u5f85\u51fa\u5e93\u7684\u51fa\u5e93\u5355\u624d\u5141\u8bb8\u8fdb\u884c\u51fa\u5e93\u64cd\u4f5c", (Object[])new Object[0]);
            bill.setDeliveryStatus(ProductDeliveryStatus.DELIVERED);
            DeliveryBillProductStockRegister register = this.deliveryBillProductStockContext.getRegisterByOperationType(bill.getProductStockOperationType());
            Validate.notNull((Object)register, (String)"\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7c7b\u578b\u7684\u51fa\u5e93\u5355\u64cd\u4f5c\u5e93\u5b58\u7684\u6ce8\u518c\u5668", (Object[])new Object[0]);
            List<ProductDeliveryBillDetail> details = this.productDeliveryBillDetailRepository.findListByBillId(bill.getId());
            Validate.notEmpty(details, (String)"\u65e0\u6cd5\u627e\u5230\u51fa\u5e93\u5355\u8be6\u60c5", (Object[])new Object[0]);
            for (ProductDeliveryBillDetail detail : details) {
                DeliveryProductStockOperationDto operationDto = this.buildOperationDto(bill, detail);
                register.execute(operationDto);
            }
        }
        this.productDeliveryBillRepository.updateBatchById(bills);
    }

    @Transactional
    public void handleRejectedBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        List<ProductDeliveryBill> bills = this.productDeliveryBillRepository.findListByIds(ids);
        if (CollectionUtils.isEmpty(bills)) {
            return;
        }
        for (ProductDeliveryBill bill : bills) {
            ProductDeliveryStatus status = bill.getDeliveryStatus();
            Validate.isTrue((boolean)ProductDeliveryStatus.WAIT_DELIVERY.equals((Object)status), (String)"\u53ea\u6709\u5f85\u51fa\u5e93\u7684\u51fa\u5e93\u5355\u624d\u5141\u8bb8\u9a73\u56de", (Object[])new Object[0]);
            bill.setDeliveryStatus(ProductDeliveryStatus.REJECTED);
        }
        this.productDeliveryBillRepository.updateBatchById(bills);
    }

    @Transactional
    public void handleVoidBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        List<ProductDeliveryBill> bills = this.productDeliveryBillRepository.findListByIds(ids);
        if (CollectionUtils.isEmpty(bills)) {
            return;
        }
        for (ProductDeliveryBill bill : bills) {
            ProductDeliveryStatus status = bill.getDeliveryStatus();
            Validate.isTrue((ProductDeliveryStatus.WAIT_DELIVERY.equals((Object)status) || ProductDeliveryStatus.DELIVERED.equals((Object)status) ? 1 : 0) != 0, (String)"\u53ea\u6709\u5f85\u51fa\u5e93\u548c\u5df2\u51fa\u5e93\u7684\u51fa\u5e93\u5355\u624d\u5141\u8bb8\u8fdb\u884c\u4f5c\u5e9f\u64cd\u4f5c", (Object[])new Object[0]);
            bill.setDeliveryStatus(ProductDeliveryStatus.VOIDED);
            if (!ProductDeliveryStatus.DELIVERED.equals((Object)status)) continue;
            DeliveryBillProductStockRegister register = this.deliveryBillProductStockContext.getRegisterByOperationType(bill.getProductStockOperationType());
            Validate.notNull((Object)register, (String)"\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7c7b\u578b\u7684\u51fa\u5e93\u5355\u64cd\u4f5c\u5e93\u5b58\u7684\u6ce8\u518c\u5668", (Object[])new Object[0]);
            List<ProductDeliveryBillDetail> details = this.productDeliveryBillDetailRepository.findListByBillId(bill.getId());
            Validate.notEmpty(details, (String)"\u65e0\u6cd5\u627e\u5230\u51fa\u5e93\u5355\u8be6\u60c5", (Object[])new Object[0]);
            for (ProductDeliveryBillDetail detail : details) {
                DeliveryProductStockOperationDto operationDto = this.buildOperationDto(bill, detail);
                register.rescind(operationDto);
            }
        }
        this.productDeliveryBillRepository.updateBatchById(bills);
    }

    private DeliveryProductStockOperationDto buildOperationDto(ProductDeliveryBill bill, ProductDeliveryBillDetail detail) {
        DeliveryProductStockOperationDto operationDto = (DeliveryProductStockOperationDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)detail, DeliveryProductStockOperationDto.class, HashSet.class, ArrayList.class, new String[0]);
        operationDto.setWarehouseCode(bill.getDeliveryWarehouseCode());
        operationDto.setWarehouseName(bill.getDeliveryWarehouseName());
        operationDto.setBillType(ProductStockBillType.DELIVERY_ORDER.name());
        operationDto.setBillCode(bill.getDeliveryBillCode());
        operationDto.setQuantity(detail.getCurrentQuantity());
        return operationDto;
    }
}

