/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.psi.product.local.service.productstock.internal;

import com.biz.crm.dms.business.psi.product.local.repository.productstock.ProductStockDetailRepository;
import com.biz.crm.dms.business.psi.product.sdk.dto.productstock.DeliveryStockDto;
import com.biz.crm.dms.business.psi.product.sdk.service.productstock.DeliveryStockVoService;
import com.biz.crm.dms.business.psi.product.sdk.service.productstock.ProductStockVoService;
import com.biz.crm.dms.business.psi.product.sdk.vo.productstock.DeliveryStockVo;
import com.biz.crm.dms.business.psi.product.sdk.vo.productstock.ProductStockVo;
import com.biz.crm.mdm.business.warehouse.sdk.service.WarehouseVoService;
import com.biz.crm.mdm.business.warehouse.sdk.vo.WarehouseVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeliveryStockVoServiceImpl
implements DeliveryStockVoService {
    @Autowired(required=false)
    private WarehouseVoService warehouseVoService;
    @Autowired(required=false)
    private ProductStockVoService productStockVoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ProductStockDetailRepository productStockDetailRepository;

    public List<DeliveryStockVo> findByDeliveryStockDto(List<DeliveryStockDto> list) {
        this.validate(list);
        ArrayList<DeliveryStockVo> result = new ArrayList<DeliveryStockVo>();
        for (DeliveryStockDto dto : list) {
            List defaultProductStocks;
            WarehouseVo defaultWarehouse;
            List productStocks;
            ArrayList productStockVos = new ArrayList();
            WarehouseVo warehouse = this.warehouseVoService.findDetailsByCityCode(dto.getCityCode());
            if (warehouse != null && CollectionUtils.isNotEmpty((Collection)(productStocks = this.productStockVoService.findByWarehouseAndProducts(warehouse.getWarehouseCode(), dto.getProductCodes())))) {
                productStocks.stream().forEach(item -> item.setWarehouseDefault(Boolean.valueOf(true)));
                productStockVos.addAll(productStocks);
            }
            if ((defaultWarehouse = this.warehouseVoService.findDetailsByWarehouseDefault(Boolean.valueOf(true))) != null && CollectionUtils.isNotEmpty((Collection)(defaultProductStocks = this.productStockVoService.findByWarehouseAndProducts(defaultWarehouse.getWarehouseCode(), dto.getProductCodes())))) {
                defaultProductStocks.stream().forEach(item -> item.setWarehouseDefault(Boolean.valueOf(true)));
                productStockVos.addAll(defaultProductStocks);
            }
            List deliveryStockVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(productStockVos, ProductStockVo.class, DeliveryStockVo.class, HashSet.class, ArrayList.class, new String[0]);
            deliveryStockVos.stream().forEach(item -> item.setOrderCode(dto.getOrderCode()));
            result.addAll(deliveryStockVos);
        }
        return result;
    }

    public List<DeliveryStockVo> findByDeliveryMaterialStockDto(List<DeliveryStockDto> list) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(list), (String)"\u67e5\u8be2\u7269\u6599\u5e93\u5b58\u4f20\u5165\u53c2\u6570\u4e3a\u7a7a", (Object[])new Object[0]);
        ArrayList<DeliveryStockVo> result = new ArrayList<DeliveryStockVo>();
        for (DeliveryStockDto deliveryStockDto : list) {
            Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)deliveryStockDto.getProductCodes()), (String)"\u67e5\u8be2\u7269\u6599\u5e93\u5b58\u65f6\uff0c\u7269\u6599\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)deliveryStockDto.getOrderCode(), (String)"\u67e5\u8be2\u7269\u6599\u5e93\u5b58\u65f6\uff0c\u8ba2\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)deliveryStockDto.getStockType(), (String)"\u67e5\u8be2\u7269\u6599\u5e93\u5b58\u65f6\uff0c\u5e93\u5b58\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            ArrayList productCodeList = new ArrayList();
            deliveryStockDto.getProductCodes().forEach(s -> productCodeList.add(s));
            List defaultProductStocks = this.productStockVoService.findByTypeAndProductCodeIn(productCodeList, deliveryStockDto.getStockType());
            List deliveryStockVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)defaultProductStocks, ProductStockVo.class, DeliveryStockVo.class, HashSet.class, ArrayList.class, new String[0]);
            deliveryStockVos.stream().forEach(item -> item.setOrderCode(deliveryStockDto.getOrderCode()));
            result.addAll(deliveryStockVos);
        }
        return result;
    }

    public List<DeliveryStockVo> findByOrderCodeAndItemCode(List<DeliveryStockDto> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        ArrayList<String> codes = new ArrayList<String>();
        for (DeliveryStockDto deliveryStockDto : list) {
            String code = deliveryStockDto.getOrderCode() + deliveryStockDto.getOrderItemCode();
            codes.add(code);
        }
        return this.productStockDetailRepository.findByOrderCodeAndItemCode(codes);
    }

    private void validate(List<DeliveryStockDto> list) {
        Validate.notEmpty(list, (String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (DeliveryStockDto dto : list) {
            Validate.notBlank((CharSequence)dto.getOrderCode(), (String)"\u8ba2\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)dto.getCityCode(), (String)"\u57ce\u5e02\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notEmpty((Collection)dto.getProductCodes(), (String)"\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
    }
}

