/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.psi.product.local.service.productstock.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.psi.product.local.entity.productstock.ProductSecurityStock;
import com.biz.crm.dms.business.psi.product.local.entity.productstock.ProductSecurityStockQuantity;
import com.biz.crm.dms.business.psi.product.local.entity.productstock.ProductSecurityStockQuantityWarehouse;
import com.biz.crm.dms.business.psi.product.local.repository.productstock.ProductSecurityStockQuantityRepository;
import com.biz.crm.dms.business.psi.product.local.repository.productstock.ProductSecurityStockQuantityWarehouseRepository;
import com.biz.crm.dms.business.psi.product.local.repository.productstock.ProductSecurityStockRepository;
import com.biz.crm.dms.business.psi.product.local.service.productstock.ProductSecurityStockVoService;
import com.biz.crm.dms.business.psi.product.sdk.dto.productstock.ProductSecurityStockConditionDto;
import com.biz.crm.dms.business.psi.product.sdk.dto.productstock.ProductSecurityStockCreateDto;
import com.biz.crm.dms.business.psi.product.sdk.dto.productstock.ProductSecurityStockPaginationDto;
import com.biz.crm.dms.business.psi.product.sdk.dto.productstock.ProductSecurityStockQuantityDto;
import com.biz.crm.dms.business.psi.product.sdk.dto.productstock.ProductSecurityStockQuantityWarehouseDto;
import com.biz.crm.dms.business.psi.product.sdk.dto.productstock.ProductSecurityStockUpdateDto;
import com.biz.crm.dms.business.psi.product.sdk.vo.productstock.ProductSecurityStockQuantityVo;
import com.biz.crm.dms.business.psi.product.sdk.vo.productstock.ProductSecurityStockQuantityWarehouseVo;
import com.biz.crm.dms.business.psi.product.sdk.vo.productstock.ProductSecurityStockVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProductSecurityStockVoServiceImpl
implements ProductSecurityStockVoService {
    @Autowired(required=false)
    private ProductSecurityStockRepository productSecurityStockRepository;
    @Autowired(required=false)
    private ProductSecurityStockQuantityRepository productSecurityStockQuantityRepository;
    @Autowired(required=false)
    private ProductSecurityStockQuantityWarehouseRepository productSecurityStockQuantityWarehouseRepository;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Page<ProductSecurityStockVo> findByConditions(Pageable pageable, ProductSecurityStockPaginationDto paginationDto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        paginationDto = Optional.ofNullable(paginationDto).orElse(new ProductSecurityStockPaginationDto());
        paginationDto.setTenantCode(TenantUtils.getTenantCode());
        Page<ProductSecurityStockVo> page = this.productSecurityStockRepository.findByConditions(pageable, paginationDto);
        List records = page.getRecords();
        if (CollectionUtils.isNotEmpty((Collection)records)) {
            List productCodes = records.stream().map(ProductSecurityStockVo::getProductCode).collect(Collectors.toList());
            Map ProductVoMap = this.productVoService.findMainDetailsByProductCodes(productCodes).stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity(), (o1, o2) -> o2));
            for (ProductSecurityStockVo record : records) {
                ProductVo productVo = (ProductVo)ProductVoMap.get(record.getProductCode());
                Validate.notNull((Object)productVo, (String)"\u65e0\u6cd5\u83b7\u53d6\u7684\u5546\u54c1\u4fe1\u606f", (Object[])new Object[0]);
                record.setProductLevelCode(productVo.getProductLevelCode());
                record.setProductLevelName(productVo.getProductLevelName());
                record.setProductSpec(productVo.getSpec());
                record.setProductUnit(productVo.getSaleUnit());
            }
        }
        return page;
    }

    private List<ProductSecurityStockVo> findDetailsByConditions(ProductSecurityStockConditionDto dto) {
        return this.productSecurityStockRepository.findDetailsByConditions(dto, TenantUtils.getTenantCode());
    }

    @Override
    public ProductSecurityStockVo findDetailsById(String id) {
        if (!StringUtils.isNotEmpty((CharSequence)id)) {
            return null;
        }
        ProductSecurityStockVo securityStockVo = this.productSecurityStockRepository.findDetailsById(id, TenantUtils.getTenantCode());
        if (Objects.isNull(securityStockVo)) {
            return null;
        }
        List productVos = this.productVoService.findMainDetailsByProductCodes((List)Lists.newArrayList((Object[])new String[]{securityStockVo.getProductCode()}));
        ProductVo productVo = (ProductVo)productVos.stream().findFirst().orElseThrow(() -> new IllegalArgumentException("\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u5546\u54c1\u4fe1\u606f"));
        securityStockVo.setProductSpec(productVo.getSpec());
        securityStockVo.setProductUnit(productVo.getSaleUnit());
        return securityStockVo;
    }

    @Override
    @Transactional
    public ProductSecurityStockVo create(ProductSecurityStockCreateDto createDto) {
        return this.createForm(createDto);
    }

    private ProductSecurityStockVo createForm(ProductSecurityStockCreateDto createDto) {
        this.validateCreate(createDto);
        ProductSecurityStock securityStock = (ProductSecurityStock)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)createDto, ProductSecurityStock.class, HashSet.class, ArrayList.class, new String[0]));
        securityStock.setTenantCode(TenantUtils.getTenantCode());
        securityStock.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        securityStock.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        ProductSecurityStockConditionDto dto = new ProductSecurityStockConditionDto();
        dto.setProductCode(securityStock.getProductCode());
        List<ProductSecurityStockVo> detailsByConditions = this.productSecurityStockRepository.findDetailsByConditions(dto, TenantUtils.getTenantCode());
        if (CollectionUtils.isNotEmpty(detailsByConditions)) {
            Validate.isTrue((detailsByConditions.size() == 1 ? 1 : 0) != 0, (String)"\u67e5\u8be2\u5230\u591a\u6761\u5546\u54c1\u6570\u636e\uff0c\u53ef\u80fd\u7531\u4e8e\u810f\u6570\u636e\u5f15\u8d77", (Object[])new Object[0]);
            securityStock.setId(detailsByConditions.get(0).getId());
        }
        this.productSecurityStockRepository.saveOrUpdate((Object)securityStock);
        ProductSecurityStockVo securityStockVo = (ProductSecurityStockVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)securityStock, ProductSecurityStockVo.class, HashSet.class, ArrayList.class, new String[0]);
        List<ProductSecurityStockQuantityVo> quantityVos = this.saveDetails(securityStock, createDto.getQuantityDtos());
        securityStockVo.setQuantityVos(quantityVos);
        List productVos = this.productVoService.findMainDetailsByProductCodes((List)Lists.newArrayList((Object[])new String[]{securityStockVo.getProductCode()}));
        ProductVo productVo = (ProductVo)productVos.stream().findFirst().orElseThrow(() -> new IllegalArgumentException("\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u5546\u54c1\u4fe1\u606f"));
        securityStockVo.setProductSpec(productVo.getSpec());
        securityStockVo.setProductUnit(productVo.getSaleUnit());
        return securityStockVo;
    }

    private List<ProductSecurityStockQuantityVo> saveDetails(ProductSecurityStock securityStock, List<ProductSecurityStockQuantityDto> quantityDtos) {
        return quantityDtos.stream().map(quantityDto -> {
            ProductSecurityStockQuantity securityStockQuantity = (ProductSecurityStockQuantity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(quantityDto, ProductSecurityStockQuantity.class, HashSet.class, ArrayList.class, new String[0])));
            securityStockQuantity.setTenantCode(TenantUtils.getTenantCode());
            securityStockQuantity.setSecurityStockId(securityStock.getId());
            this.productSecurityStockQuantityRepository.save((Object)securityStockQuantity);
            ProductSecurityStockQuantityVo productSecurityStockQuantityVo = (ProductSecurityStockQuantityVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)securityStockQuantity, ProductSecurityStockQuantityVo.class, HashSet.class, ArrayList.class, new String[0]);
            List warehouseDtos = quantityDto.getWarehouseDtos();
            if (CollectionUtils.isNotEmpty((Collection)warehouseDtos)) {
                ArrayList productSecurityStockQuantityWarehouses = (ArrayList)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)warehouseDtos, ProductSecurityStockQuantityWarehouseDto.class, ProductSecurityStockQuantityWarehouse.class, HashSet.class, ArrayList.class, new String[0]);
                for (ProductSecurityStockQuantityWarehouse securityStockQuantityWarehouse : productSecurityStockQuantityWarehouses) {
                    securityStockQuantityWarehouse.setTenantCode(TenantUtils.getTenantCode());
                    securityStockQuantityWarehouse.setSecurityStockQuantityId(securityStockQuantity.getId());
                }
                this.productSecurityStockQuantityWarehouseRepository.saveBatch(productSecurityStockQuantityWarehouses);
                ArrayList productSecurityStockQuantityWarehouseVos = (ArrayList)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)productSecurityStockQuantityWarehouses, ProductSecurityStockQuantityWarehouse.class, ProductSecurityStockQuantityWarehouseVo.class, HashSet.class, ArrayList.class, new String[0]);
                productSecurityStockQuantityVo.setWarehouseVos((List)productSecurityStockQuantityWarehouseVos);
            }
            return productSecurityStockQuantityVo;
        }).collect(Collectors.toList());
    }

    private void validateCreate(ProductSecurityStockCreateDto createDto) {
        Validate.notNull((Object)createDto.getProductCode(), (String)"\u5b89\u5168\u5e93\u5b58\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)createDto.getProductName(), (String)"\u5b89\u5168\u5e93\u5b58\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((Collection)createDto.getQuantityDtos(), (String)"\u5b89\u5168\u5e93\u5b58\u6570\u91cf\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        int count = 0;
        for (ProductSecurityStockQuantityDto quantityDto : createDto.getQuantityDtos()) {
            Validate.notNull((Object)quantityDto.getSecurityStockQuantity(), (String)"\u5b89\u5168\u5e93\u5b58\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)quantityDto.getSort(), (String)"\u5b89\u5168\u5e93\u5b58\u6570\u91cf\u6392\u5e8f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)quantityDto.getApplicableToAll(), (String)"\u5b89\u5168\u5e93\u5b58\u6570\u91cf\u662f\u5426\u4f7f\u7528\u6240\u6709\u4ed3\u5e93\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            if (!quantityDto.getApplicableToAll().booleanValue()) {
                Validate.notEmpty((Collection)quantityDto.getWarehouseDtos(), (String)"\u975e\u9002\u7528\u4e8e\u6240\u6709\u4ed3\u5e93\u7684\u5b89\u5168\u5e93\u5b58\u6570\u91cf\u4fe1\u606f\u5bf9\u5e94\u4ed3\u5e93\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                for (ProductSecurityStockQuantityWarehouseDto warehouseDto : quantityDto.getWarehouseDtos()) {
                    Validate.notNull((Object)warehouseDto.getWarehouseCode(), (String)"\u5b89\u5168\u5e93\u5b58\u9002\u7528\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                    Validate.notNull((Object)warehouseDto.getWarehouseName(), (String)"\u5b89\u5168\u5e93\u5b58\u9002\u7528\u4ed3\u5e93\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                }
                continue;
            }
            Validate.isTrue((boolean)CollectionUtils.isEmpty((Collection)quantityDto.getWarehouseDtos()), (String)"\u9002\u7528\u4e8e\u6240\u6709\u4ed3\u5e93\u7684\u5b89\u5168\u5e93\u5b58\u6570\u91cf\u4fe1\u606f\u4e0d\u80fd\u6709\u5bf9\u5e94\u4ed3\u5e93\u6570\u636e", (Object[])new Object[0]);
            ++count;
        }
        Validate.isTrue((count == 1 || count == 0 ? 1 : 0) != 0, (String)"\u9002\u7528\u4e8e\u6240\u6709\u4ed3\u5e93\u552f\u4e00", (Object[])new Object[0]);
        String productCode = createDto.getProductCode();
        List quantityDtos = createDto.getQuantityDtos();
        for (ProductSecurityStockQuantityDto quantityDto : quantityDtos) {
            if (quantityDto.getApplicableToAll().booleanValue()) {
                ProductSecurityStockConditionDto dto = new ProductSecurityStockConditionDto();
                dto.setProductCode(productCode);
                dto.setApplicableToAll(Boolean.valueOf(true));
                List<ProductSecurityStockVo> detailsByConditions = this.findDetailsByConditions(dto);
                Validate.isTrue((boolean)CollectionUtils.isEmpty(detailsByConditions), (String)("[\u5546\u54c1:" + productCode + "]\u5df2\u5b58\u5728\u9002\u7528\u4e8e\u5168\u90e8\u4ed3\u5e93\u7684\u6570\u636e"), (Object[])new Object[0]);
                continue;
            }
            List warehouseDtos = quantityDto.getWarehouseDtos();
            for (ProductSecurityStockQuantityWarehouseDto warehouseDto : warehouseDtos) {
                ProductSecurityStockConditionDto dto = new ProductSecurityStockConditionDto();
                dto.setProductCode(productCode);
                dto.setWarehouseCode(warehouseDto.getWarehouseCode());
                List<ProductSecurityStockVo> detailsByConditions = this.findDetailsByConditions(dto);
                Validate.isTrue((boolean)CollectionUtils.isEmpty(detailsByConditions), (String)("[\u5546\u54c1:" + productCode + "]\u5df2\u5b58\u5728\u5f53\u524d\u4ed3\u5e93\u7684\u6570\u636e"), (Object[])new Object[0]);
            }
        }
    }

    @Override
    @Transactional
    public ProductSecurityStockVo update(ProductSecurityStockUpdateDto updateDto) {
        return this.updateForm(updateDto);
    }

    private ProductSecurityStockVo updateForm(ProductSecurityStockUpdateDto updateDto) {
        this.validateUpdate(updateDto);
        ProductSecurityStock securityStock = (ProductSecurityStock)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)updateDto, ProductSecurityStock.class, HashSet.class, ArrayList.class, new String[0]));
        this.productSecurityStockRepository.updateById((Object)securityStock);
        ProductSecurityStockVo securityStockVo = (ProductSecurityStockVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)securityStock, ProductSecurityStockVo.class, HashSet.class, ArrayList.class, new String[0]);
        List<ProductSecurityStockQuantity> productSecurityStockQuantities = this.productSecurityStockQuantityRepository.findBySecurityStockId(securityStock.getId());
        Validate.notEmpty(productSecurityStockQuantities, (String)"\u65e0\u6cd5\u627e\u5230\u5b89\u5168\u5e93\u5b58\u7684\u6570\u91cf\u4fe1\u606f", (Object[])new Object[0]);
        List<String> quantityIds = productSecurityStockQuantities.stream().map(UuidEntity::getId).collect(Collectors.toList());
        this.productSecurityStockQuantityRepository.removeByIds(quantityIds);
        this.productSecurityStockQuantityWarehouseRepository.deleteByQuantityIds(quantityIds);
        List<ProductSecurityStockQuantityVo> quantityVos = this.saveDetails(securityStock, updateDto.getQuantityDtos());
        securityStockVo.setQuantityVos(quantityVos);
        List productVos = this.productVoService.findMainDetailsByProductCodes((List)Lists.newArrayList((Object[])new String[]{securityStockVo.getProductCode()}));
        ProductVo productVo = (ProductVo)productVos.stream().findFirst().orElseThrow(() -> new IllegalArgumentException("\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u5546\u54c1\u4fe1\u606f"));
        securityStockVo.setProductSpec(productVo.getSpec());
        securityStockVo.setProductUnit(productVo.getSaleUnit());
        return securityStockVo;
    }

    private void validateUpdate(ProductSecurityStockUpdateDto updateDto) {
        Validate.notNull((Object)updateDto.getId(), (String)"\u53d8\u66f4\u5b89\u5168\u5e93\u5b58\u65f6id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)updateDto.getProductCode(), (String)"\u5b89\u5168\u5e93\u5b58\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)updateDto.getProductName(), (String)"\u5b89\u5168\u5e93\u5b58\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((Collection)updateDto.getQuantityDtos(), (String)"\u5b89\u5168\u5e93\u5b58\u6570\u91cf\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        int count = 0;
        for (ProductSecurityStockQuantityDto quantityDto : updateDto.getQuantityDtos()) {
            Validate.notNull((Object)quantityDto.getSecurityStockQuantity(), (String)"\u5b89\u5168\u5e93\u5b58\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)quantityDto.getSort(), (String)"\u5b89\u5168\u5e93\u5b58\u6570\u91cf\u6392\u5e8f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)quantityDto.getApplicableToAll(), (String)"\u5b89\u5168\u5e93\u5b58\u6570\u91cf\u662f\u5426\u4f7f\u7528\u6240\u6709\u4ed3\u5e93\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            if (!quantityDto.getApplicableToAll().booleanValue()) {
                Validate.notEmpty((Collection)quantityDto.getWarehouseDtos(), (String)"\u975e\u9002\u7528\u4e8e\u6240\u6709\u4ed3\u5e93\u7684\u5b89\u5168\u5e93\u5b58\u6570\u91cf\u4fe1\u606f\u5bf9\u5e94\u4ed3\u5e93\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                for (ProductSecurityStockQuantityWarehouseDto warehouseDto : quantityDto.getWarehouseDtos()) {
                    Validate.notNull((Object)warehouseDto.getWarehouseCode(), (String)"\u5b89\u5168\u5e93\u5b58\u9002\u7528\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                    Validate.notNull((Object)warehouseDto.getWarehouseName(), (String)"\u5b89\u5168\u5e93\u5b58\u9002\u7528\u4ed3\u5e93\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                }
                continue;
            }
            Validate.isTrue((boolean)CollectionUtils.isEmpty((Collection)quantityDto.getWarehouseDtos()), (String)"\u9002\u7528\u4e8e\u6240\u6709\u4ed3\u5e93\u7684\u5b89\u5168\u5e93\u5b58\u6570\u91cf\u4fe1\u606f\u4e0d\u80fd\u6709\u5bf9\u5e94\u4ed3\u5e93\u6570\u636e", (Object[])new Object[0]);
            ++count;
        }
        Validate.isTrue((count == 1 || count == 0 ? 1 : 0) != 0, (String)"\u9002\u7528\u4e8e\u6240\u6709\u4ed3\u5e93\u552f\u4e00", (Object[])new Object[0]);
        List quantityDtos = updateDto.getQuantityDtos();
        HashSet warehouseSet = new HashSet();
        ArrayList warehouseList = new ArrayList();
        for (ProductSecurityStockQuantityDto quantityDto : quantityDtos) {
            List warehouseDtos = quantityDto.getWarehouseDtos();
            if (CollectionUtils.isEmpty((Collection)warehouseDtos)) continue;
            List codes = warehouseDtos.stream().map(ProductSecurityStockQuantityWarehouseDto::getWarehouseCode).collect(Collectors.toList());
            warehouseSet.addAll(codes);
            warehouseList.addAll(codes);
        }
        Validate.isTrue((warehouseSet.size() == warehouseList.size() ? 1 : 0) != 0, (String)"\u4ed3\u5e93\u5b58\u5728\u91cd\u590d", (Object[])new Object[0]);
        ProductSecurityStockConditionDto dto = new ProductSecurityStockConditionDto();
        dto.setProductCode(updateDto.getProductCode());
        List<ProductSecurityStockVo> productSecurityStockVoList = this.findDetailsByConditions(dto);
        List exclude = productSecurityStockVoList.stream().filter(e -> !e.getId().equals(updateDto.getId())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(exclude)) {
            ArrayList warehouse = new ArrayList();
            Boolean isAll = false;
            for (ProductSecurityStockVo vo : exclude) {
                List quantityVos = vo.getQuantityVos();
                if (!CollectionUtils.isNotEmpty((Collection)quantityVos)) continue;
                for (ProductSecurityStockQuantityVo quantityVo : quantityVos) {
                    if (quantityVo.getApplicableToAll().booleanValue()) {
                        isAll = true;
                        continue;
                    }
                    warehouse.addAll(quantityVo.getWarehouseVos());
                }
            }
            List isTrueList = quantityDtos.stream().filter(e -> e.getApplicableToAll() == true).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(isTrueList)) {
                Validate.isTrue((isAll == false ? 1 : 0) != 0, (String)"\u5f53\u524d\u5546\u54c1\u5df2\u5b58\u5728\u9002\u7528\u4e8e\u5168\u90e8\u7684\u9ed8\u8ba4\u4ed3\u5e93\u6570\u636e", (Object[])new Object[0]);
            }
            if (CollectionUtils.isNotEmpty(warehouse)) {
                List wareHouseCodes = warehouse.stream().map(ProductSecurityStockQuantityWarehouseVo::getWarehouseCode).collect(Collectors.toList());
                wareHouseCodes.retainAll(warehouseSet);
                Validate.isTrue((boolean)CollectionUtils.isEmpty(wareHouseCodes), (String)("\u5f53\u524d\u5546\u54c1\u7684\u5b89\u5168\u4ed3\u5e93\u4e0e\u5df2\u6709\u7684\u5b89\u5168\u4ed3\u5e93\u91cd\u590d,\u4ed3\u5e93\u7f16\u7801[" + wareHouseCodes.toString() + "]"), (Object[])new Object[0]);
            }
        }
    }

    @Override
    @Transactional
    public void deleteBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        this.productSecurityStockRepository.deleteBatch(ids);
    }

    @Override
    @Transactional
    public List<ProductSecurityStockVo> createBatch(List<ProductSecurityStockCreateDto> createDtos) {
        Validate.notEmpty(createDtos, (String)"\u6279\u91cf\u4fdd\u5b58\u65f6\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (ProductSecurityStockCreateDto productSecurityStockCreateDto : createDtos) {
            this.validateCreate(productSecurityStockCreateDto);
        }
        HashMap map = new HashMap();
        for (ProductSecurityStockCreateDto dto : createDtos) {
            List quantityDtos = dto.getQuantityDtos();
            if (map.containsKey(dto.getProductCode())) {
                if (!CollectionUtils.isNotEmpty((Collection)quantityDtos)) continue;
                for (ProductSecurityStockQuantityDto quantityDto : quantityDtos) {
                    if (quantityDto.getApplicableToAll().booleanValue()) continue;
                    List warehouseDtos = quantityDto.getWarehouseDtos();
                    warehouseDtos.stream().forEach(item -> Validate.isTrue((!((List)map.get(dto.getProductCode())).contains(item.getWarehouseCode()) ? 1 : 0) != 0, (String)"%s\u5546\u54c1\uff0c%s\u5b89\u5168\u5e93\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[]{dto.getProductCode(), item.getWarehouseCode()}));
                }
                continue;
            }
            ArrayList warehouse = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)quantityDtos)) {
                ProductSecurityStockQuantityDto quantityDto;
                quantityDto = quantityDtos.iterator();
                while (quantityDto.hasNext()) {
                    ProductSecurityStockQuantityDto quantityDto2 = (ProductSecurityStockQuantityDto)quantityDto.next();
                    if (quantityDto2.getApplicableToAll().booleanValue()) continue;
                    List warehouseDtos = quantityDto2.getWarehouseDtos();
                    warehouseDtos.stream().forEach(item -> warehouse.add(item.getWarehouseCode()));
                }
            }
            map.put(dto.getProductCode(), warehouse);
        }
        ArrayList<ProductSecurityStockVo> arrayList = new ArrayList<ProductSecurityStockVo>();
        Map<String, List<ProductSecurityStockCreateDto>> productMap = createDtos.stream().collect(Collectors.groupingBy(ProductSecurityStockCreateDto::getProductCode));
        for (Map.Entry<String, List<ProductSecurityStockCreateDto>> entry : productMap.entrySet()) {
            ProductSecurityStockCreateDto dto = new ProductSecurityStockCreateDto();
            ArrayList quantityDtos = new ArrayList();
            List<ProductSecurityStockCreateDto> values = entry.getValue();
            dto.setProductCode(values.get(0).getProductCode());
            dto.setProductName(values.get(0).getProductName());
            for (ProductSecurityStockCreateDto value : values) {
                quantityDtos.addAll(value.getQuantityDtos());
            }
            dto.setQuantityDtos(quantityDtos);
            ProductSecurityStockVo productSecurityStockVo = this.create(dto);
            arrayList.add(productSecurityStockVo);
        }
        return arrayList;
    }
}

