/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.psi.product.local.service.productstock.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.psi.product.local.entity.productstock.ProductStock;
import com.biz.crm.dms.business.psi.product.local.entity.productstock.ProductStockDetail;
import com.biz.crm.dms.business.psi.product.local.repository.productstock.ProductStockDetailRepository;
import com.biz.crm.dms.business.psi.product.local.repository.productstock.ProductStockRepository;
import com.biz.crm.dms.business.psi.product.sdk.dto.productstock.ProductStockDetailPaginationDto;
import com.biz.crm.dms.business.psi.product.sdk.enums.productstock.StockType;
import com.biz.crm.dms.business.psi.product.sdk.service.productstock.ProductStockDetailVoService;
import com.biz.crm.dms.business.psi.product.sdk.vo.productstock.ProductStockDetailVo;
import com.biz.crm.mdm.business.material.sdk.service.MaterialVoService;
import com.biz.crm.mdm.business.material.sdk.vo.MaterialVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class ProductStockDetailVoServiceImpl
implements ProductStockDetailVoService {
    @Autowired(required=false)
    private ProductStockDetailRepository productStockDetailRepository;
    @Autowired(required=false)
    private ProductStockRepository productStockRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private MaterialVoService materialVoService;

    public Page<ProductStockDetailVo> findFreezeStockDetailByConditions(Pageable pageable, ProductStockDetailPaginationDto paginationDto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        paginationDto = Optional.ofNullable(paginationDto).orElse(new ProductStockDetailPaginationDto());
        paginationDto.setTenantCode(TenantUtils.getTenantCode());
        return this.productStockDetailRepository.findFreezeStockDetailByConditions(pageable, paginationDto);
    }

    public Page<ProductStockDetailVo> findStockOperationDetailByConditions(Pageable pageable, ProductStockDetailPaginationDto paginationDto) {
        Validate.notNull((Object)paginationDto, (String)"\u4f20\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)paginationDto.getStockId(), (String)"\u67e5\u8be2\u5e93\u5b58\u660e\u7ec6\u65f6\uff0c\u4f20\u5165\u5e93\u5b58id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ProductStock productStock = (ProductStock)((Object)this.productStockRepository.getById((Serializable)((Object)paginationDto.getStockId())));
        Validate.notNull((Object)((Object)productStock), (String)"\u5546\u54c1\u5e93\u5b58\u4fe1\u606f\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        paginationDto = Optional.ofNullable(paginationDto).orElse(new ProductStockDetailPaginationDto());
        paginationDto.setTenantCode(TenantUtils.getTenantCode());
        Page<ProductStockDetailVo> page = this.productStockDetailRepository.findStockOperationDetailByConditions(pageable, paginationDto);
        if (CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
            List productCodes = page.getRecords().stream().map(ProductStockDetailVo::getProductCode).distinct().collect(Collectors.toList());
            Set materialCodes = page.getRecords().stream().map(ProductStockDetailVo::getProductCode).collect(Collectors.toSet());
            if (StockType.PRODUCT.getKey().equals(productStock.getType())) {
                Map ProductVoMap = this.productVoService.findMainDetailsByProductCodes(productCodes).stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity(), (o1, o2) -> o2));
                for (ProductStockDetailVo record : page.getRecords()) {
                    ProductVo productVo = (ProductVo)ProductVoMap.get(record.getProductCode());
                    Validate.notNull((Object)productVo, (String)"\u65e0\u6cd5\u83b7\u53d6\u7684\u5546\u54c1\u4fe1\u606f", (Object[])new Object[0]);
                    record.setProductUnit(productVo.getSaleUnit());
                }
            }
            if (StockType.MATERIAL.getKey().equals(productStock.getType())) {
                Map materialVos = this.materialVoService.findDetailByMaterialCodes(materialCodes).stream().collect(Collectors.toMap(MaterialVo::getMaterialCode, Function.identity(), (o1, o2) -> o2));
                for (ProductStockDetailVo record : page.getRecords()) {
                    MaterialVo materialVo = (MaterialVo)materialVos.get(record.getProductCode());
                    Validate.notNull((Object)materialVo, (String)"\u65e0\u6cd5\u83b7\u53d6\u7684\u5546\u54c1\u4fe1\u606f", (Object[])new Object[0]);
                    record.setProductUnit(materialVo.getStandardUnit());
                }
            }
        }
        return page;
    }

    public List<ProductStockDetailVo> findFreezeStockDetailByOrderCodeAndOrderItemCode(String orderCode, String orderItemCode) {
        if (StringUtils.isBlank((CharSequence)orderCode) || StringUtils.isBlank((CharSequence)orderItemCode)) {
            return Lists.newArrayList();
        }
        List<ProductStockDetail> freezes = this.productStockDetailRepository.findFreezeStockDetailByOrderCodeAndOrderItemCode(orderCode, orderItemCode);
        Collection productStockDetailVos = this.nebulaToolkitService.copyCollectionByWhiteList(freezes, ProductStockDetail.class, ProductStockDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)productStockDetailVos);
    }
}

