/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.psi.product.local.service.productstock.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.dms.business.psi.product.local.entity.productstock.ProductStock;
import com.biz.crm.dms.business.psi.product.local.entity.productstock.ProductStockDetail;
import com.biz.crm.dms.business.psi.product.local.repository.productstock.ProductStockDetailRepository;
import com.biz.crm.dms.business.psi.product.local.repository.productstock.ProductStockRepository;
import com.biz.crm.dms.business.psi.product.local.service.productstock.ProductStockService;
import com.biz.crm.dms.business.psi.product.sdk.dto.productstock.ProductStockOperationDto;
import com.biz.crm.dms.business.psi.product.sdk.enums.productstock.ProductStockOperation;
import com.biz.crm.dms.business.psi.product.sdk.enums.productstock.StockType;
import com.biz.crm.mdm.business.material.sdk.service.MaterialVoService;
import com.biz.crm.mdm.business.material.sdk.vo.MaterialVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.warehouse.sdk.service.WarehouseVoService;
import com.biz.crm.mdm.business.warehouse.sdk.vo.WarehouseVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProductStockServiceImpl
implements ProductStockService {
    @Autowired(required=false)
    private ProductStockRepository productStockRepository;
    @Autowired(required=false)
    private ProductStockDetailRepository productStockDetailRepository;
    @Autowired(required=false)
    private GenerateCodeService generateCode;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private WarehouseVoService warehouseVoService;
    @Autowired(required=false)
    private MaterialVoService materialVoService;

    private ProductStock create(String warehouseCode, String productCode, String type) {
        ProductVo productVo = new ProductVo();
        MaterialVo materialVo = new MaterialVo();
        if (StockType.PRODUCT.getKey().equals(type)) {
            List productVos = this.productVoService.findMainDetailsByProductCodes((List)Lists.newArrayList((Object[])new String[]{productCode}));
            productVo = (ProductVo)productVos.stream().findFirst().orElseThrow(() -> new IllegalArgumentException("\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u5546\u54c1\u4fe1\u606f"));
        }
        if (StockType.MATERIAL.getKey().equals(type)) {
            materialVo = this.materialVoService.findDetailByMaterialCode(productCode);
            Validate.notNull((Object)materialVo, (String)"\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u7269\u6599\u4fe1\u606f", (Object[])new Object[0]);
        }
        WarehouseVo warehouseVo = this.warehouseVoService.findDetailsByCode(warehouseCode);
        Validate.notNull((Object)warehouseVo, (String)"\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u4ed3\u5e93\u4fe1\u606f", (Object[])new Object[0]);
        ProductStock productStock = new ProductStock();
        productStock.setTenantCode(TenantUtils.getTenantCode());
        productStock.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        productStock.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        productStock.setStockCode((String)this.generateCode.generateCode("SPKC", 1).get(0));
        if (StockType.PRODUCT.getKey().equals(type)) {
            productStock.setProductCode(productVo.getProductCode());
            productStock.setProductName(productVo.getProductName());
            productStock.setProductLevelCode(productVo.getProductLevelCode());
            productStock.setProductLevelName(productVo.getProductLevelName());
        }
        if (StockType.MATERIAL.getKey().equals(type)) {
            productStock.setProductCode(materialVo.getMaterialCode());
            productStock.setProductName(materialVo.getMaterialName());
            productStock.setProductLevelCode(materialVo.getProductLevelCode());
            productStock.setProductLevelName(materialVo.getProductLevelName());
        }
        productStock.setWarehouseCode(warehouseVo.getWarehouseCode());
        productStock.setWarehouseName(warehouseVo.getWarehouseName());
        productStock.setAvailableStock(BigDecimal.ZERO);
        productStock.setFrozenStock(BigDecimal.ZERO);
        productStock.setTotalStock(BigDecimal.ZERO);
        productStock.setType(type);
        this.productStockRepository.save((Object)productStock);
        return productStock;
    }

    @Override
    @Transactional
    public ProductStock store(ProductStockOperationDto productStockOperationDto) {
        Validate.notNull((Object)productStockOperationDto.getWarehouseCode(), (String)"\u53d8\u66f4\u5e93\u5b58\u5546\u54c1\u6570\u91cf\u65f6\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)productStockOperationDto.getProductCode(), (String)"\u53d8\u66f4\u5e93\u5b58\u5546\u54c1\u6570\u91cf\u65f6\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)productStockOperationDto.getQuantity(), (String)"\u53d8\u66f4\u5e93\u5b58\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ProductStock productStock = this.productStockRepository.findByWarehouseCodeAndProductCode(productStockOperationDto.getWarehouseCode(), productStockOperationDto.getProductCode(), TenantUtils.getTenantCode());
        if (Objects.isNull((Object)productStock)) {
            productStock = this.create(productStockOperationDto.getWarehouseCode(), productStockOperationDto.getProductCode(), productStockOperationDto.getType());
        }
        productStock.setTotalStock(productStock.getTotalStock().add(productStockOperationDto.getQuantity().abs()));
        productStock.setAvailableStock(productStock.getAvailableStock().add(productStockOperationDto.getQuantity().abs()));
        this.productStockRepository.updateById((Object)productStock);
        this.createProductStockDetail(productStockOperationDto, productStock, ProductStockOperation.STORE, productStockOperationDto.getQuantity().abs(), BigDecimal.ZERO);
        return productStock;
    }

    private void createProductStockDetail(ProductStockOperationDto productStockOperationDto, ProductStock productStock, ProductStockOperation productStockOperation, BigDecimal stockQuantity, BigDecimal frozenQuantity) {
        ProductStockDetail productStockDetail = new ProductStockDetail();
        productStockDetail.setTenantCode(TenantUtils.getTenantCode());
        productStockDetail.setStockId(productStock.getId());
        productStockDetail.setStockCode(productStock.getStockCode());
        productStockDetail.setWarehouseCode(productStock.getWarehouseCode());
        productStockDetail.setWarehouseName(productStock.getWarehouseName());
        productStockDetail.setProductCode(productStock.getProductCode());
        productStockDetail.setProductName(productStock.getProductName());
        productStockDetail.setProductStockOperation(productStockOperation);
        productStockDetail.setProductStockOperationType(productStockOperationDto.getProductStockOperationType());
        productStockDetail.setCustomerCode(productStockOperationDto.getCustomerCode());
        productStockDetail.setCustomerName(productStockOperationDto.getCustomerName());
        productStockDetail.setOriginalOrderCode(productStockOperationDto.getOriginalOrderCode());
        productStockDetail.setOrderType(productStockOperationDto.getOrderType());
        productStockDetail.setOrderCode(productStockOperationDto.getOrderCode());
        productStockDetail.setOrderItemCode(productStockOperationDto.getOrderItemCode());
        productStockDetail.setBillType(productStockOperationDto.getBillType());
        productStockDetail.setBillCode(productStockOperationDto.getBillCode());
        productStockDetail.setStockQuantity(stockQuantity);
        productStockDetail.setTotalStockQuantity(productStock.getTotalStock());
        productStockDetail.setFrozenQuantity(frozenQuantity);
        productStockDetail.setTotalFrozenQuantity(productStock.getFrozenStock());
        this.productStockDetailRepository.save((Object)productStockDetail);
    }

    @Override
    @Transactional
    public ProductStock deliver(ProductStockOperationDto productStockOperationDto) {
        Validate.notNull((Object)productStockOperationDto.getWarehouseCode(), (String)"\u53d8\u66f4\u5e93\u5b58\u5546\u54c1\u6570\u91cf\u65f6\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)productStockOperationDto.getProductCode(), (String)"\u53d8\u66f4\u5e93\u5b58\u5546\u54c1\u6570\u91cf\u65f6\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)productStockOperationDto.getQuantity(), (String)"\u53d8\u66f4\u5e93\u5b58\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ProductStock productStock = this.productStockRepository.findByWarehouseCodeAndProductCode(productStockOperationDto.getWarehouseCode(), productStockOperationDto.getProductCode(), TenantUtils.getTenantCode());
        Validate.notNull((Object)((Object)productStock), (String)"\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u5546\u54c1\u5e93\u5b58\u6570\u636e", (Object[])new Object[0]);
        BigDecimal totalStock = productStock.getTotalStock().subtract(productStockOperationDto.getQuantity().abs());
        Validate.isTrue((totalStock.compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"\u5e93\u5b58\u6570\u91cf\u4e0d\u8db3", (Object[])new Object[0]);
        productStock.setTotalStock(totalStock);
        BigDecimal availableStock = productStock.getAvailableStock().subtract(productStockOperationDto.getQuantity().abs());
        Validate.isTrue((availableStock.compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"\u53ef\u7528\u5e93\u5b58\u6570\u91cf\u4e0d\u8db3", (Object[])new Object[0]);
        productStock.setAvailableStock(availableStock);
        this.productStockRepository.updateById((Object)productStock);
        this.createProductStockDetail(productStockOperationDto, productStock, ProductStockOperation.DELIVER, productStockOperationDto.getQuantity().abs().negate(), BigDecimal.ZERO);
        return productStock;
    }

    @Override
    @Transactional
    public ProductStock frozen(ProductStockOperationDto productStockOperationDto) {
        Validate.notNull((Object)productStockOperationDto.getWarehouseCode(), (String)"\u53d8\u66f4\u5e93\u5b58\u5546\u54c1\u6570\u91cf\u65f6\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)productStockOperationDto.getProductCode(), (String)"\u53d8\u66f4\u5e93\u5b58\u5546\u54c1\u6570\u91cf\u65f6\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)productStockOperationDto.getQuantity(), (String)"\u53d8\u66f4\u5e93\u5b58\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ProductStock productStock = this.productStockRepository.findByWarehouseCodeAndProductCode(productStockOperationDto.getWarehouseCode(), productStockOperationDto.getProductCode(), TenantUtils.getTenantCode());
        Validate.notNull((Object)((Object)productStock), (String)"\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u5546\u54c1[%s]\u5728\u4ed3\u5e93[%s]\u7684\u5e93\u5b58\u6570\u636e", (Object[])new Object[]{productStockOperationDto.getProductCode(), productStockOperationDto.getWarehouseCode()});
        BigDecimal availableStock = productStock.getAvailableStock().subtract(productStockOperationDto.getQuantity().abs());
        productStock.setAvailableStock(availableStock);
        productStock.setFrozenStock(productStock.getFrozenStock().add(productStockOperationDto.getQuantity().abs()));
        this.productStockRepository.updateById((Object)productStock);
        this.createProductStockDetail(productStockOperationDto, productStock, ProductStockOperation.FROZEN, BigDecimal.ZERO, productStockOperationDto.getQuantity().abs());
        return productStock;
    }

    @Override
    @Transactional
    public ProductStock thaw(ProductStockOperationDto productStockOperationDto) {
        Validate.notNull((Object)productStockOperationDto.getWarehouseCode(), (String)"\u53d8\u66f4\u5e93\u5b58\u5546\u54c1\u6570\u91cf\u65f6\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)productStockOperationDto.getProductCode(), (String)"\u53d8\u66f4\u5e93\u5b58\u5546\u54c1\u6570\u91cf\u65f6\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)productStockOperationDto.getQuantity(), (String)"\u53d8\u66f4\u5e93\u5b58\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ProductStock productStock = this.productStockRepository.findByWarehouseCodeAndProductCode(productStockOperationDto.getWarehouseCode(), productStockOperationDto.getProductCode(), TenantUtils.getTenantCode());
        Validate.notNull((Object)((Object)productStock), (String)"\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u5546\u54c1\u5e93\u5b58\u6570\u636e", (Object[])new Object[0]);
        productStock.setAvailableStock(productStock.getAvailableStock().add(productStockOperationDto.getQuantity().abs()));
        BigDecimal frozenStock = productStock.getFrozenStock().subtract(productStockOperationDto.getQuantity().abs());
        Validate.isTrue((frozenStock.compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"\u51bb\u7ed3\u5e93\u5b58\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e0", (Object[])new Object[0]);
        productStock.setFrozenStock(frozenStock);
        this.productStockRepository.updateById((Object)productStock);
        this.createProductStockDetail(productStockOperationDto, productStock, ProductStockOperation.THAW, BigDecimal.ZERO, productStockOperationDto.getQuantity().abs().negate());
        return productStock;
    }

    @Override
    public List<ProductStock> findByTypeAndProductCodeIn(List<String> productCodes, String type) {
        if (CollectionUtils.isEmpty(productCodes) || StringUtils.isBlank((CharSequence)type)) {
            return Lists.newArrayList();
        }
        return this.productStockRepository.findByTypeAndProductCodeIn(productCodes, type);
    }

    @Override
    public List<ProductStock> findByWarehouseAndProducts(String warehouseCode, Set<String> productCodes) {
        if (CollectionUtils.isEmpty(productCodes) || StringUtils.isBlank((CharSequence)warehouseCode)) {
            return Lists.newArrayList();
        }
        return this.productStockRepository.findByWarehouseAndProducts(warehouseCode, productCodes);
    }

    @Override
    public List<ProductStock> findByWarehouseCode(String warehouseCode) {
        if (StringUtils.isBlank((CharSequence)warehouseCode)) {
            return new ArrayList<ProductStock>();
        }
        return this.productStockRepository.findByWarehouseCode(warehouseCode);
    }

    @Override
    public void updateWarehouseMsg(String warehouseCode, String warehouseName) {
        Validate.isTrue((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{warehouseCode, warehouseName}), (String)"\u66f4\u65b0\u5e93\u5b58\u4fe1\u606f\uff0c\u7f3a\u5931\u4ed3\u5e93\u7f16\u7801\u6216\u8005\u4ed3\u5e93\u540d\u79f0", (Object[])new Object[0]);
        this.productStockRepository.updateWarehouseMsg(warehouseCode, warehouseName);
    }
}

