/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.psi.product.local.service.productstock.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.psi.product.local.entity.productstock.ProductStock;
import com.biz.crm.dms.business.psi.product.local.repository.productstock.ProductStockRepository;
import com.biz.crm.dms.business.psi.product.local.service.productstock.ProductStockService;
import com.biz.crm.dms.business.psi.product.sdk.dto.productstock.ProductStockOperationDto;
import com.biz.crm.dms.business.psi.product.sdk.dto.productstock.ProductStockPaginationDto;
import com.biz.crm.dms.business.psi.product.sdk.enums.productstock.StockType;
import com.biz.crm.dms.business.psi.product.sdk.service.productstock.ProductStockVoService;
import com.biz.crm.dms.business.psi.product.sdk.vo.productstock.ProductStockVo;
import com.biz.crm.mdm.business.material.sdk.service.MaterialVoService;
import com.biz.crm.mdm.business.material.sdk.vo.MaterialVo;
import com.biz.crm.mdm.business.product.level.sdk.dto.RelateProductLevelCodeQueryDto;
import com.biz.crm.mdm.business.product.level.sdk.service.ProductLevelVoSdkService;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProductStockVoServiceImpl
implements ProductStockVoService {
    @Autowired(required=false)
    private ProductStockService productStockService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private RedissonClient redissonClient;
    @Autowired(required=false)
    private ProductStockRepository productStockRepository;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private ProductLevelVoSdkService productLevelVoSdkService;
    @Autowired(required=false)
    private MaterialVoService materialVoService;

    public Page<ProductStockVo> findByConditions(Pageable pageable, ProductStockPaginationDto paginationDto) {
        Page<ProductStockVo> page;
        List records;
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        paginationDto = Optional.ofNullable(paginationDto).orElse(new ProductStockPaginationDto());
        paginationDto.setTenantCode(TenantUtils.getTenantCode());
        if (StringUtils.isNotBlank((CharSequence)paginationDto.getProductLevelCode())) {
            Set<String> productCodeSet = this.findProductCodeSetByProductLevelCode(paginationDto.getProductLevelCode(), paginationDto.getType());
            if (CollectionUtils.isEmpty(productCodeSet)) {
                return new Page();
            }
            paginationDto.setProductCodeSet(productCodeSet);
            paginationDto.setProductLevelCode(null);
        }
        if (CollectionUtils.isNotEmpty((Collection)(records = (page = this.productStockRepository.findByConditions(pageable, paginationDto)).getRecords())) && paginationDto.getType().equals(StockType.PRODUCT.getKey())) {
            List productCodes = records.stream().map(ProductStockVo::getProductCode).collect(Collectors.toList());
            Map ProductVoMap = this.productVoService.findMainDetailsByProductCodes(productCodes).stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity(), (o1, o2) -> o2));
            for (ProductStockVo record : records) {
                ProductVo productVo = (ProductVo)ProductVoMap.get(record.getProductCode());
                Validate.notNull((Object)productVo, (String)"\u65e0\u6cd5\u83b7\u53d6\u7684\u5546\u54c1\u4fe1\u606f", (Object[])new Object[0]);
                record.setProductLevelCode(productVo.getProductLevelCode());
                record.setProductLevelName(productVo.getProductLevelName());
                record.setProductUnit(productVo.getSaleUnit());
                record.setSpec(productVo.getSpec());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)records) && paginationDto.getType().equals(StockType.MATERIAL.getKey())) {
            Set materialCodes = records.stream().map(ProductStockVo::getProductCode).collect(Collectors.toSet());
            List materials = this.materialVoService.findDetailByMaterialCodes(materialCodes);
            Validate.notEmpty((Collection)materials, (String)"\u672a\u83b7\u53d6\u5230\u7269\u6599\u4fe1\u606f", (Object[])new Object[0]);
            Map materialMap = materials.stream().collect(Collectors.toMap(MaterialVo::getMaterialCode, Function.identity(), (o1, o2) -> o2));
            for (ProductStockVo record : records) {
                MaterialVo materialVo = (MaterialVo)materialMap.get(record.getProductCode());
                Validate.notNull((Object)materialVo, (String)"\u65e0\u6cd5\u83b7\u53d6\u7269\u6599\u4fe1\u606f", (Object[])new Object[0]);
                record.setCostPrice(materialVo.getCostPrice());
                record.setMaterialType(materialVo.getMaterialType());
                record.setProductUnit(materialVo.getStandardUnit());
                record.setSpec(materialVo.getSpecification());
            }
        }
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public ProductStockVo orderFrozen(ProductStockOperationDto productStockOperationDto) {
        Validate.notNull((Object)productStockOperationDto.getOrderType(), (String)"\u51bb\u7ed3\u5546\u54c1\u5e93\u5b58\u65f6\uff0c\u8ba2\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)productStockOperationDto.getOrderCode(), (String)"\u51bb\u7ed3\u5546\u54c1\u5e93\u5b58\u65f6\uff0c\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)productStockOperationDto.getCustomerCode(), (String)"\u51bb\u7ed3\u5546\u54c1\u5e93\u5b58\u65f6\uff0c\u5ba2\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)productStockOperationDto.getCustomerName(), (String)"\u51bb\u7ed3\u5546\u54c1\u5e93\u5b58\u65f6\uff0c\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)productStockOperationDto.getWarehouseCode(), (String)"\u53d8\u66f4\u5e93\u5b58\u5546\u54c1\u6570\u91cf\u65f6\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)productStockOperationDto.getProductCode(), (String)"\u53d8\u66f4\u5e93\u5b58\u5546\u54c1\u6570\u91cf\u65f6\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Object transactionStatus = null;
        RLock rLock = this.redissonClient.getLock(String.format("PRODUCT_STOCK_LOCK:%s:%s", productStockOperationDto.getWarehouseCode(), productStockOperationDto.getProductCode()));
        rLock.lock(5000L, TimeUnit.MILLISECONDS);
        try {
            ProductStockVo productStockVo;
            if (StringUtils.isBlank((CharSequence)productStockOperationDto.getProductStockOperationType())) {
                productStockOperationDto.setProductStockOperationType("ORDER_FROZEN");
            }
            ProductStock frozen = this.productStockService.frozen(productStockOperationDto);
            ProductStockVo productStockVo2 = productStockVo = (ProductStockVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)frozen, ProductStockVo.class, HashSet.class, ArrayList.class, new String[0]);
            return productStockVo2;
        }
        finally {
            if (rLock.isHeldByCurrentThread()) {
                rLock.unlock();
            }
        }
    }

    public List<ProductStockVo> frozenBatch(List<ProductStockOperationDto> productStockOperationDtos) {
        ArrayList<ProductStockVo> list = new ArrayList<ProductStockVo>();
        for (ProductStockOperationDto dto : productStockOperationDtos) {
            ProductStockVo productStockVo = this.orderFrozen(dto);
            list.add(productStockVo);
        }
        return list;
    }

    public List<ProductStockVo> thawBatch(List<ProductStockOperationDto> productStockOperationDtos) {
        ArrayList<ProductStockVo> list = new ArrayList<ProductStockVo>();
        for (ProductStockOperationDto dto : productStockOperationDtos) {
            ProductStockVo productStockVo = this.orderCloseThaw(dto);
            list.add(productStockVo);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public ProductStockVo orderCloseThaw(ProductStockOperationDto productStockOperationDto) {
        Validate.notNull((Object)productStockOperationDto.getOrderType(), (String)"\u89e3\u51bb\u5546\u54c1\u5e93\u5b58\u65f6\uff0c\u8ba2\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)productStockOperationDto.getOrderCode(), (String)"\u89e3\u51bb\u5546\u54c1\u5e93\u5b58\u65f6\uff0c\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)productStockOperationDto.getCustomerCode(), (String)"\u89e3\u51bb\u5546\u54c1\u5e93\u5b58\u65f6\uff0c\u5ba2\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)productStockOperationDto.getCustomerName(), (String)"\u89e3\u51bb\u5546\u54c1\u5e93\u5b58\u65f6\uff0c\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)productStockOperationDto.getWarehouseCode(), (String)"\u53d8\u66f4\u5e93\u5b58\u5546\u54c1\u6570\u91cf\u65f6\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)productStockOperationDto.getProductCode(), (String)"\u53d8\u66f4\u5e93\u5b58\u5546\u54c1\u6570\u91cf\u65f6\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Object transactionStatus = null;
        RLock rLock = this.redissonClient.getLock(String.format("PRODUCT_STOCK_LOCK:%s:%s", productStockOperationDto.getWarehouseCode(), productStockOperationDto.getProductCode()));
        rLock.lock(5000L, TimeUnit.MILLISECONDS);
        try {
            ProductStockVo productStockVo;
            if (StringUtils.isBlank((CharSequence)productStockOperationDto.getProductStockOperationType())) {
                productStockOperationDto.setProductStockOperationType("ORDER_CLOSE_THAW");
            }
            ProductStock thaw = this.productStockService.thaw(productStockOperationDto);
            ProductStockVo productStockVo2 = productStockVo = (ProductStockVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)thaw, ProductStockVo.class, HashSet.class, ArrayList.class, new String[0]);
            return productStockVo2;
        }
        finally {
            rLock.unlock();
        }
    }

    public List<ProductStockVo> findByTypeAndProductCodeIn(List<String> productCodes, String type) {
        if (CollectionUtils.isEmpty(productCodes) || StringUtils.isBlank((CharSequence)type)) {
            return Lists.newArrayList();
        }
        List<ProductStock> productStocks = this.productStockService.findByTypeAndProductCodeIn(productCodes, type);
        Collection productStockVos = this.nebulaToolkitService.copyCollectionByWhiteList(productStocks, ProductStock.class, ProductStockVo.class, HashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)productStockVos);
    }

    public List<ProductStockVo> findByWarehouseAndProducts(String warehouseCode, Set<String> productCodes) {
        if (CollectionUtils.isEmpty(productCodes) || StringUtils.isBlank((CharSequence)warehouseCode)) {
            return Lists.newArrayList();
        }
        List<ProductStock> productStocks = this.productStockService.findByWarehouseAndProducts(warehouseCode, productCodes);
        Collection productStockVos = this.nebulaToolkitService.copyCollectionByWhiteList(productStocks, ProductStock.class, ProductStockVo.class, HashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)productStockVos);
    }

    public List<ProductStockVo> findByProductCodes(List<String> productCodes) {
        if (CollectionUtils.isEmpty(productCodes)) {
            return Lists.newArrayList();
        }
        return this.productStockRepository.findByProductCodes(productCodes);
    }

    private Set<String> findProductCodeSetByProductLevelCode(String productLevelCode, String stockType) {
        HashSet validateSet = Sets.newHashSet((Object[])new String[]{StockType.PRODUCT.getKey(), StockType.MATERIAL.getKey()});
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{productLevelCode, stockType}) || !validateSet.contains(stockType)) {
            return Sets.newHashSet();
        }
        RelateProductLevelCodeQueryDto levelCodeQueryDto = new RelateProductLevelCodeQueryDto();
        levelCodeQueryDto.setSearchType(Integer.valueOf(-1));
        levelCodeQueryDto.setProductLevelCodeSet((Set)Sets.newHashSet((Object[])new String[]{productLevelCode}));
        Map mapLevelCode = this.productLevelVoSdkService.findByRelateProductLevelCodeQueryDto(levelCodeQueryDto);
        if (mapLevelCode.isEmpty()) {
            return Sets.newHashSet();
        }
        Set productLevelCodeSet = mapLevelCode.keySet();
        if (stockType.equals(StockType.PRODUCT.getKey())) {
            List productList = this.productVoService.findByProductLevelCodes((List)Lists.newArrayList(productLevelCodeSet));
            if (CollectionUtils.isEmpty((Collection)productList)) {
                return Sets.newHashSet();
            }
            return productList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getProductCode())).map(ProductVo::getProductCode).collect(Collectors.toSet());
        }
        return this.materialVoService.findCodeByProductLevelCodes(productLevelCodeSet);
    }
}

