/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.psi.product.local.service.productstock.notifier;

import com.biz.crm.dms.business.psi.product.local.entity.productstock.ProductStock;
import com.biz.crm.dms.business.psi.product.local.repository.productstock.ProductStockRepository;
import com.biz.crm.dms.business.psi.product.local.service.productstock.ProductStockDetailService;
import com.biz.crm.dms.business.psi.product.local.service.productstock.ProductStockService;
import com.biz.crm.mdm.business.warehouse.sdk.event.WarehouseEventListener;
import com.biz.crm.mdm.business.warehouse.sdk.vo.WarehouseEventVo;
import com.biz.crm.mdm.business.warehouse.sdk.vo.WarehouseVo;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class WarehouseEventListenerImpl
implements WarehouseEventListener {
    @Autowired(required=false)
    private ProductStockRepository productStockRepository;
    @Autowired
    private ProductStockService productStockService;
    @Autowired
    private ProductStockDetailService productStockDetailService;

    public void onCreate(WarehouseEventVo vo) {
    }

    @Transactional
    public void onUpdate(WarehouseEventVo vo) {
        WarehouseVo oldWarehouse = vo.getOldWarehouse();
        WarehouseVo newWarehouse = vo.getNewWarehouse();
        String warehouseCode = oldWarehouse.getWarehouseCode();
        String warehouseName = newWarehouse.getWarehouseName();
        this.productStockService.updateWarehouseMsg(warehouseCode, warehouseName);
        this.productStockDetailService.updateWarehouseMsg(warehouseCode, warehouseName);
    }

    public void onDisable(WarehouseEventVo vo) {
    }

    public void onEnable(WarehouseEventVo vo) {
    }

    public void onDelete(WarehouseEventVo vo) {
        Validate.notNull((Object)vo, (String)"\u8c03\u7528\u5220\u9664\u4ed3\u5e93\u4e8b\u4ef6\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((Collection)vo.getWarehouseVoList(), (String)"\u8c03\u7528\u5220\u9664\u4ed3\u5e93\u4e8b\u4ef6\u65f6\uff0c\u4ed3\u5e93\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List warehouseVoList = vo.getWarehouseVoList();
        List<String> warehouseCode = warehouseVoList.stream().map(WarehouseVo::getWarehouseCode).collect(Collectors.toList());
        List<ProductStock> list = this.productStockRepository.findByWarehouseCodes(warehouseCode);
        Validate.isTrue((boolean)CollectionUtils.isEmpty(list), (String)"\u4ed3\u5e93\u5df2\u88ab\u4f7f\u7528\u8bf7\u52ff\u5220\u9664", (Object[])new Object[0]);
    }
}

