/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.psi.product.local.service.store.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.dms.business.psi.product.local.entity.productstock.ProductStock;
import com.biz.crm.dms.business.psi.product.local.entity.store.ProductStoredBill;
import com.biz.crm.dms.business.psi.product.local.entity.store.ProductStoredBillDetail;
import com.biz.crm.dms.business.psi.product.local.repository.productstock.ProductStockDetailRepository;
import com.biz.crm.dms.business.psi.product.local.repository.productstock.ProductStockRepository;
import com.biz.crm.dms.business.psi.product.local.repository.store.ProductStoredBillDetailRepository;
import com.biz.crm.dms.business.psi.product.local.repository.store.ProductStoredBillRepository;
import com.biz.crm.dms.business.psi.product.local.service.store.ProductStoredBillVoService;
import com.biz.crm.dms.business.psi.product.sdk.context.store.StoredBillProductStockContext;
import com.biz.crm.dms.business.psi.product.sdk.dto.productstock.StoredProductStockOperationDto;
import com.biz.crm.dms.business.psi.product.sdk.dto.store.ProductStoredBillCreateDto;
import com.biz.crm.dms.business.psi.product.sdk.dto.store.ProductStoredBillDetailDto;
import com.biz.crm.dms.business.psi.product.sdk.dto.store.ProductStoredBillPaginationDto;
import com.biz.crm.dms.business.psi.product.sdk.dto.store.ProductStoredBillUpdateDto;
import com.biz.crm.dms.business.psi.product.sdk.enums.productstock.ProductStockBillType;
import com.biz.crm.dms.business.psi.product.sdk.enums.productstock.ProductStockOperation;
import com.biz.crm.dms.business.psi.product.sdk.enums.store.ProductStoreStatus;
import com.biz.crm.dms.business.psi.product.sdk.event.ProductStoredListener;
import com.biz.crm.dms.business.psi.product.sdk.register.store.StoredBillProductStockRegister;
import com.biz.crm.dms.business.psi.product.sdk.vo.store.ProductStoredBillDetailVo;
import com.biz.crm.dms.business.psi.product.sdk.vo.store.ProductStoredBillVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProductStoredBillVoServiceImpl
implements ProductStoredBillVoService {
    @Autowired(required=false)
    private ProductStoredBillRepository productStoredBillRepository;
    @Autowired(required=false)
    private ProductStoredBillDetailRepository productStoredBillDetailRepository;
    @Autowired(required=false)
    private GenerateCodeService generateCode;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private StoredBillProductStockContext storedBillProductStockContext;
    @Autowired(required=false)
    private ProductStockDetailRepository productStockDetailRepository;
    @Autowired(required=false)
    private ProductStockRepository productStockRepository;
    @Autowired(required=false)
    private List<ProductStoredListener> productStoredListeners;

    @Override
    public Page<ProductStoredBillVo> findByConditions(Pageable pageable, ProductStoredBillPaginationDto paginationDto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        paginationDto = Optional.ofNullable(paginationDto).orElse(new ProductStoredBillPaginationDto());
        paginationDto.setTenantCode(TenantUtils.getTenantCode());
        return this.productStoredBillRepository.findByConditions(pageable, paginationDto);
    }

    @Override
    public ProductStoredBillVo findDetailsById(String id) {
        if (!StringUtils.isNotEmpty((CharSequence)id)) {
            return null;
        }
        ProductStoredBill bill = this.productStoredBillRepository.findDetailsById(id, TenantUtils.getTenantCode());
        if (Objects.isNull((Object)bill)) {
            return null;
        }
        ProductStoredBillVo billVo = (ProductStoredBillVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)bill, ProductStoredBillVo.class, HashSet.class, ArrayList.class, new String[0]);
        List detailVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(this.productStoredBillDetailRepository.findListByBillId(bill.getId()), ProductStoredBillDetail.class, ProductStoredBillDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
        billVo.setDetailVos(detailVos);
        return billVo;
    }

    @Override
    public ProductStoredBillVo findDetailsByCode(String code) {
        if (!StringUtils.isNotEmpty((CharSequence)code)) {
            return null;
        }
        ProductStoredBill bill = this.productStoredBillRepository.findDetailsByCode(code, TenantUtils.getTenantCode());
        if (Objects.isNull((Object)bill)) {
            return null;
        }
        ProductStoredBillVo billVo = (ProductStoredBillVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)bill, ProductStoredBillVo.class, HashSet.class, ArrayList.class, new String[0]);
        List detailVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(this.productStoredBillDetailRepository.findListByBillId(bill.getId()), ProductStoredBillDetail.class, ProductStoredBillDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
        billVo.setDetailVos(detailVos);
        return billVo;
    }

    @Override
    @Transactional
    public ProductStoredBillVo create(ProductStoredBillCreateDto createDto) {
        return this.createForm(createDto);
    }

    private ProductStoredBillVo createForm(ProductStoredBillCreateDto createDto) {
        this.validateCreate(createDto);
        ProductStoredBill bill = (ProductStoredBill)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)createDto, ProductStoredBill.class, HashSet.class, ArrayList.class, new String[0]));
        bill.setTenantCode(TenantUtils.getTenantCode());
        bill.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        bill.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        bill.setStoredBillCode((String)this.generateCode.generateCode("SPRK", 1).get(0));
        bill.setStoredStatus(ProductStoreStatus.WAIT_STORE);
        this.productStoredBillRepository.save((Object)bill);
        ProductStoredBillVo billVo = (ProductStoredBillVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)bill, ProductStoredBillVo.class, HashSet.class, ArrayList.class, new String[0]);
        List<ProductStoredBillDetailVo> detailVos = this.saveDetails(bill, createDto.getDetailDtos());
        billVo.setDetailVos(detailVos);
        this.handleStoreBatch(Lists.newArrayList((Object[])new String[]{bill.getId()}));
        if (CollectionUtils.isNotEmpty(this.productStoredListeners)) {
            this.productStoredListeners.forEach(listener -> listener.onCreate(billVo));
        }
        return billVo;
    }

    private List<ProductStoredBillDetailVo> saveDetails(ProductStoredBill bill, List<ProductStoredBillDetailDto> detailDtos) {
        List billDetails = (List)this.nebulaToolkitService.copyCollectionByWhiteList(detailDtos, ProductStoredBillDetailDto.class, ProductStoredBillDetail.class, HashSet.class, ArrayList.class, new String[0]);
        for (ProductStoredBillDetail billDetail : billDetails) {
            billDetail.setTenantCode(TenantUtils.getTenantCode());
            billDetail.setStoredBillId(bill.getId());
            billDetail.setStoredBillCode(bill.getStoredBillCode());
        }
        this.productStoredBillDetailRepository.saveBatch(billDetails);
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)billDetails, ProductStoredBillDetail.class, ProductStoredBillDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    private void validateCreate(ProductStoredBillCreateDto createDto) {
        Validate.notNull((Object)createDto.getStoredTime(), (String)"\u5165\u5e93\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)createDto.getStoreWarehouseCode(), (String)"\u5165\u5e93\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)createDto.getStoreWarehouseName(), (String)"\u5165\u5e93\u4ed3\u5e93\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)createDto.getProductStockOperationType(), (String)"\u5546\u54c1\u5e93\u5b58\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((Collection)createDto.getDetailDtos(), (String)"\u5546\u54c1\u5165\u5e93\u5355\u5546\u54c1\u884c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public ProductStoredBillVo update(ProductStoredBillUpdateDto updateDto) {
        return this.updateForm(updateDto);
    }

    private ProductStoredBillVo updateForm(ProductStoredBillUpdateDto updateDto) {
        this.validateUpdate(updateDto);
        ProductStoredBill bill = (ProductStoredBill)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)updateDto, ProductStoredBill.class, HashSet.class, ArrayList.class, new String[0]));
        bill.setStoredStatus(ProductStoreStatus.WAIT_STORE);
        this.productStoredBillRepository.updateById((Object)bill);
        ProductStoredBillVo billVo = (ProductStoredBillVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)bill, ProductStoredBillVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.productStoredBillDetailRepository.deleteByBillId(bill.getId());
        List<ProductStoredBillDetailVo> detailVos = this.saveDetails(bill, updateDto.getDetailDtos());
        billVo.setDetailVos(detailVos);
        return billVo;
    }

    private void validateUpdate(ProductStoredBillUpdateDto updateDto) {
        Validate.notBlank((CharSequence)updateDto.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)updateDto.getStoredBillCode(), (String)"\u5165\u5e93\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)updateDto.getStoredTime(), (String)"\u5165\u5e93\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)updateDto.getStoreWarehouseCode(), (String)"\u5165\u5e93\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)updateDto.getStoreWarehouseName(), (String)"\u5165\u5e93\u4ed3\u5e93\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)updateDto.getProductStockOperationType(), (String)"\u5546\u54c1\u5e93\u5b58\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((Collection)updateDto.getDetailDtos(), (String)"\u5546\u54c1\u5165\u5e93\u5355\u5546\u54c1\u884c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ProductStoredBill bill = this.productStoredBillRepository.findDetailsById(updateDto.getId(), TenantUtils.getTenantCode());
        Validate.isTrue((boolean)Objects.nonNull((Object)bill), (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5165\u5e93\u5355", (Object[])new Object[0]);
        ProductStoreStatus storedStatus = bill.getStoredStatus();
        Validate.isTrue((ProductStoreStatus.WAIT_STORE.equals((Object)storedStatus) || ProductStoreStatus.REJECTED.equals((Object)storedStatus) ? 1 : 0) != 0, (String)"\u53ea\u6709\u5f85\u5165\u5e93\u548c\u5df2\u9a73\u56de\u7684\u5165\u5e93\u5355\u624d\u5141\u8bb8\u7f16\u8f91", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public void deleteBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        List<ProductStoredBill> bills = this.productStoredBillRepository.findListByIds(ids);
        if (CollectionUtils.isEmpty(bills)) {
            return;
        }
        for (ProductStoredBill bill : bills) {
            ProductStoreStatus status = bill.getStoredStatus();
            Validate.isTrue((ProductStoreStatus.WAIT_STORE.equals((Object)status) || ProductStoreStatus.REJECTED.equals((Object)status) || ProductStoreStatus.VOIDED.equals((Object)status) ? 1 : 0) != 0, (String)"\u53ea\u6709\u5f85\u5165\u5e93\u3001\u5df2\u4f5c\u5e9f\u548c\u5df2\u9a73\u56de\u7684\u5165\u5e93\u5355\u624d\u5141\u8bb8\u5220\u9664", (Object[])new Object[0]);
        }
        this.productStoredBillRepository.deleteBatch(ids);
    }

    @Override
    @Transactional
    public void handleStoreBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        List<ProductStoredBill> bills = this.productStoredBillRepository.findListByIds(ids);
        if (CollectionUtils.isEmpty(bills)) {
            return;
        }
        for (ProductStoredBill bill : bills) {
            ProductStoreStatus status = bill.getStoredStatus();
            Validate.isTrue((boolean)ProductStoreStatus.WAIT_STORE.equals((Object)status), (String)"\u53ea\u6709\u5f85\u5165\u5e93\u7684\u5165\u5e93\u5355\u624d\u5141\u8bb8\u8fdb\u884c\u5165\u5e93\u64cd\u4f5c", (Object[])new Object[0]);
            bill.setStoredStatus(ProductStoreStatus.STORED);
            StoredBillProductStockRegister register = this.storedBillProductStockContext.getRegisterByOperationType(bill.getProductStockOperationType());
            Validate.notNull((Object)register, (String)"\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7c7b\u578b\u7684\u5165\u5e93\u5355\u64cd\u4f5c\u5e93\u5b58\u7684\u6ce8\u518c\u5668", (Object[])new Object[0]);
            List<ProductStoredBillDetail> details = this.productStoredBillDetailRepository.findListByBillId(bill.getId());
            Validate.notEmpty(details, (String)"\u65e0\u6cd5\u627e\u5230\u5165\u5e93\u5355\u8be6\u60c5", (Object[])new Object[0]);
            for (ProductStoredBillDetail detail : details) {
                StoredProductStockOperationDto operationDto = this.buildOperationDto(bill, detail);
                register.execute(operationDto);
            }
        }
        this.productStoredBillRepository.updateBatchById(bills);
    }

    private StoredProductStockOperationDto buildOperationDto(ProductStoredBill bill, ProductStoredBillDetail detail) {
        StoredProductStockOperationDto operationDto = (StoredProductStockOperationDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)detail, StoredProductStockOperationDto.class, HashSet.class, ArrayList.class, new String[0]);
        operationDto.setWarehouseCode(bill.getStoreWarehouseCode());
        operationDto.setWarehouseName(bill.getStoreWarehouseName());
        operationDto.setBillType(ProductStockBillType.STORED_ORDER.name());
        operationDto.setBillCode(bill.getStoredBillCode());
        operationDto.setProductLevelName(detail.getProductLevel());
        operationDto.setQuantity(detail.getStoredQuantity());
        operationDto.setType(bill.getType());
        return operationDto;
    }

    @Override
    public void handleRejectedBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        List<ProductStoredBill> bills = this.productStoredBillRepository.findListByIds(ids);
        if (CollectionUtils.isEmpty(bills)) {
            return;
        }
        for (ProductStoredBill bill : bills) {
            ProductStoreStatus status = bill.getStoredStatus();
            Validate.isTrue((boolean)ProductStoreStatus.WAIT_STORE.equals((Object)status), (String)"\u53ea\u6709\u5f85\u5165\u5e93\u7684\u5165\u5e93\u5355\u624d\u5141\u8bb8\u9a73\u56de", (Object[])new Object[0]);
            bill.setStoredStatus(ProductStoreStatus.REJECTED);
        }
        this.productStoredBillRepository.updateBatchById(bills);
    }

    @Override
    @Transactional
    public void handleVoidBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        List<ProductStoredBill> bills = this.productStoredBillRepository.findListByIds(ids);
        if (CollectionUtils.isEmpty(bills)) {
            return;
        }
        for (ProductStoredBill bill : bills) {
            ProductStoreStatus status = bill.getStoredStatus();
            Validate.isTrue((ProductStoreStatus.WAIT_STORE.equals((Object)status) || ProductStoreStatus.STORED.equals((Object)status) ? 1 : 0) != 0, (String)"\u53ea\u6709\u5f85\u5165\u5e93\u548c\u5df2\u5165\u5e93\u7684\u5165\u5e93\u5355\u624d\u5141\u8bb8\u8fdb\u884c\u4f5c\u5e9f\u64cd\u4f5c", (Object[])new Object[0]);
            bill.setStoredStatus(ProductStoreStatus.VOIDED);
            if (!ProductStoreStatus.STORED.equals((Object)status)) continue;
            StoredBillProductStockRegister register = this.storedBillProductStockContext.getRegisterByOperationType(bill.getProductStockOperationType());
            Validate.notNull((Object)register, (String)"\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7c7b\u578b\u7684\u5165\u5e93\u5355\u64cd\u4f5c\u5e93\u5b58\u7684\u6ce8\u518c\u5668", (Object[])new Object[0]);
            List<ProductStoredBillDetail> details = this.productStoredBillDetailRepository.findListByBillId(bill.getId());
            Validate.notEmpty(details, (String)"\u65e0\u6cd5\u627e\u5230\u5165\u5e93\u5355\u8be6\u60c5", (Object[])new Object[0]);
            for (ProductStoredBillDetail detail : details) {
                BigDecimal storedQuantity;
                ArrayList<ProductStockOperation> operations = new ArrayList<ProductStockOperation>();
                operations.add(ProductStockOperation.FROZEN);
                operations.add(ProductStockOperation.DELIVER);
                ProductStock byWarehouseCodeAndProductCode = this.productStockRepository.findByWarehouseCodeAndProductCode(bill.getStoreWarehouseCode(), detail.getProductCode(), TenantUtils.getTenantCode());
                if (!Objects.nonNull((Object)byWarehouseCodeAndProductCode)) continue;
                BigDecimal availableStock = byWarehouseCodeAndProductCode.getAvailableStock();
                Validate.isTrue((availableStock.compareTo(storedQuantity = detail.getStoredQuantity()) >= 0 ? 1 : 0) != 0, (String)"\u5f53\u524d\u53ef\u7528\u5e93\u5b58\u5c0f\u4e8e\u4f5c\u5e9f\u5355\u5165\u5e93\u6570\u91cf\uff0c\u65e0\u6cd5\u4f5c\u5e9f", (Object[])new Object[0]);
            }
            for (ProductStoredBillDetail detail : details) {
                StoredProductStockOperationDto operationDto = this.buildOperationDto(bill, detail);
                register.rescind(operationDto);
            }
        }
        this.productStoredBillRepository.updateBatchById(bills);
    }

    @Override
    public List<ProductStoredBillVo> findDetailsByReceivingCode(String code) {
        List<ProductStoredBill> detailsByReceivingCode = this.productStoredBillRepository.findDetailsByReceivingCode(code);
        if (CollectionUtils.isEmpty(detailsByReceivingCode)) {
            return new ArrayList<ProductStoredBillVo>(0);
        }
        List<String> ids = detailsByReceivingCode.stream().map(UuidEntity::getId).collect(Collectors.toList());
        List<ProductStoredBillDetail> listByBillIds = this.productStoredBillDetailRepository.findListByBillIds(ids);
        Collection productStoredBillDetailVos = this.nebulaToolkitService.copyCollectionByWhiteList(listByBillIds, ProductStoredBillDetail.class, ProductStoredBillDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
        Map<String, List<ProductStoredBillDetailVo>> detailMap = productStoredBillDetailVos.stream().collect(Collectors.groupingBy(ProductStoredBillDetailVo::getStoredBillCode));
        Collection productStoredBillVos = this.nebulaToolkitService.copyCollectionByWhiteList(detailsByReceivingCode, ProductStoredBill.class, ProductStoredBillVo.class, HashSet.class, ArrayList.class, new String[0]);
        for (ProductStoredBillVo vo : productStoredBillVos) {
            List<ProductStoredBillDetailVo> detailVos = detailMap.get(vo.getStoredBillCode());
            if (!CollectionUtils.isNotEmpty(detailVos)) continue;
            vo.setDetailVos(detailVos);
        }
        return (List)productStoredBillVos;
    }
}

