package com.biz.crm.dms.business.psi.product.sdk.context.delivery;
/**
 * Created by Bao Hongbin on 2022-01-13 16:59.
 */

import com.biz.crm.dms.business.psi.product.sdk.register.delivery.DeliveryBillProductStockRegister;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @program: crm-dms
 * @description: 出库单库存操作注册器上下文
 * @author: Bao Hongbin
 * @create: 2022-01-13 16:59
 **/
@Component
public class DeliveryBillProductStockContext {

  /**
   * 储存出库单库存操作类型和出库单库存操作注册器的映射关系
   */
  private static final Map<String, DeliveryBillProductStockRegister> REGISTERS_CACHE = new ConcurrentHashMap<>();

  @Autowired(required = false)
  public DeliveryBillProductStockContext(List<DeliveryBillProductStockRegister> deliveryBillProductStockRegisters) {
    if (CollectionUtils.isNotEmpty(deliveryBillProductStockRegisters)) {
      for (DeliveryBillProductStockRegister deliveryBillProductStockRegister : deliveryBillProductStockRegisters) {
        REGISTERS_CACHE.put(deliveryBillProductStockRegister.getOperationType(), deliveryBillProductStockRegister);
      }
    }
  }

  /**
   * 根据出库单库存操作类型获取出库单库存操作注册器
   *
   * @param operationType
   * @return 出库单库存操作注册器
   */
  public DeliveryBillProductStockRegister getRegisterByOperationType(String operationType) {
    if (StringUtils.isBlank(operationType)) {
      return null;
    }
    if (CollectionUtils.isEmpty(REGISTERS_CACHE.values())) {
      return null;
    }
    return REGISTERS_CACHE.get(operationType);
  }
}
