package com.biz.crm.dms.business.psi.product.sdk.dto.delivery;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 商品出库单创建dto
 * </p>
 *
 * @author Bao Hongbin
 * @since 2022-01-15
 */
@Data
@ApiModel("商品出库单创建dto")
public class ProductDeliveryBillCreateDto {

  /**
   * 备注
   */
  @ApiModelProperty("备注")
  private String remark;

  /**
   * 出库时间
   */
  @ApiModelProperty("出库时间")
  private Date deliveryTime;

  /**
   * 经办人账号
   */
  @ApiModelProperty("经办人账号")
  private String handlerAccount;

  /**
   * 经办人姓名
   */
  @ApiModelProperty("经办人姓名")
  private String handlerName;

  /**
   * 关联发货单类型
   */
  @ApiModelProperty("关联发货单类型")
  private String relationShipmentOrderType;

  /**
   * 关联发货单编码
   */
  @ApiModelProperty("关联发货单编码")
  private String relationShipmentOrderCode;

  /**
   * 入库仓库编码
   */
  @ApiModelProperty("入库仓库编码")
  private String storeWarehouseCode;

  /**
   * 入库仓库名称
   */
  @ApiModelProperty("入库仓库名称")
  private String storeWarehouseName;

  /**
   * 出库仓库编码
   */
  @ApiModelProperty("出库仓库编码")
  private String deliveryWarehouseCode;

  /**
   * 出库仓库名称
   */
  @ApiModelProperty("出库仓库名称")
  private String deliveryWarehouseName;

  /**
   * 商品库存操作类型
   */
  @ApiModelProperty("商品库存操作类型")
  private String productStockOperationType;

  /**
   * 商品出库单明细dtos
   */
  @ApiModelProperty("商品出库单明细dtos")
  private List<ProductDeliveryBillDetailDto> detailDtos;

  /**
   * 类型(商品：product; 物料：material)
   */
  @ApiModelProperty("类型(商品：product; 物料：material)")
  private String type;
}
