package com.biz.crm.dms.business.psi.product.sdk.dto.productstock;
/**
 * Created by Bao Hongbin on 2022-01-12 15:03.
 */

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @program: crm-dms
 * @description: 出库商品库存操作dto
 * @author: Bao Hongbin
 * @create: 2022-01-12 15:03
 **/
@Data
@ApiModel("出库商品库存操作dto")
public class DeliveryProductStockOperationDto {

  /**
   * 仓库编码
   */
  @ApiModelProperty("仓库编码")
  private String warehouseCode;

  /**
   * 仓库名称
   */
  @ApiModelProperty("仓库名称")
  private String warehouseName;

  /**
   * 商品编码
   */
  @ApiModelProperty("商品编码")
  private String productCode;

  /**
   * 商品名称
   */
  @ApiModelProperty("商品名称")
  private String productName;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String customerCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  private String customerName;

  /**
   * 原始订单编号
   */
  @ApiModelProperty("原始订单编号")
  private String originalOrderCode;

  /**
   * 订单类型
   */
  @ApiModelProperty("订单类型")
  private String orderType;

  /**
   * 订单编号
   */
  @ApiModelProperty("订单编号")
  private String orderCode;

  /**
   * 订单行编号
   */
  @ApiModelProperty("订单行编号")
  private String orderItemCode;

  /**
   * 关联商品库存单据类型
   */
  @ApiModelProperty("关联商品库存单据类型")
  private String billType;

  /**
   * 关联商品库存单据编号
   */
  @ApiModelProperty("关联商品库存单据编号")
  private String billCode;

  /**
   * 本单库存操作商品数量（传入出库数量、入库数量、冻结数量、解冻数量，皆为正数）
   */
  @ApiModelProperty("本单库存操作商品数量")
  private BigDecimal quantity;
}
