package com.biz.crm.dms.business.psi.product.sdk.dto.productstock;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import lombok.Data;

import java.util.Set;

/**
 * 发货单查询库存信息dto
 * @Author: zengxingwang
 * @Date: 2022/3/8 15:58
 */
@Data
@ApiModel("发货单查询库存信息dto")
public class DeliveryStockDto {

  /**
   * 订单编码
   */
  @ApiModelProperty("订单编码")
  private String orderCode;

  /**
   * 订单编码
   */
  @ApiModelProperty("订单编码")
  private String orderItemCode;

  /**
   * 市编码
   */
  @ApiModelProperty("市编码")
  private String cityCode;

  /**
   * 仓库编码
   */
  @ApiModelProperty("仓库编码")
  private String warehouseCode;

  /**
   * 类型
   */
  @ApiModelProperty("类型(商品：product; 物料：material)")
  private String stockType;

  /**
   * 商品编码集合
   */
  @ApiModelProperty("商品编码集合")
  private Set<String> productCodes;
}
