package com.biz.crm.dms.business.psi.product.sdk.dto.productstock;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * <p>
 * 商品安全库存新增dto
 * </p>
 *
 * @author Bao Hongbin
 * @since 2022-01-07
 */
@Data
@ApiModel("商品安全库存新增dto")
public class ProductSecurityStockCreateDto {

  /**
   * 备注
   */
  @ApiModelProperty("备注")
  private String remark;

  /**
   * 商品编码
   */
  @ApiModelProperty("商品编码")
  private String productCode;

  /**
   * 商品名称
   */
  @ApiModelProperty("商品名称")
  private String productName;

  /**
   * 商品层级
   */
  @ApiModelProperty("商品层级")
  private String productLevel;

  /**
   * 规格
   */
  @ApiModelProperty("规格")
  private String spec;

  /**
   * 单位
   */
  @ApiModelProperty("单位")
  private String unit;

  /**
   * 商品安全库存数量dtos
   */
  @ApiModelProperty("商品安全库存数量dtos")
  private List<ProductSecurityStockQuantityDto> quantityDtos;
}
