package com.biz.crm.dms.business.psi.product.sdk.dto.productstock;
/**
 * Created by Bao Hongbin on 2022-01-18 15:04.
 */

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * @program: crm-dms
 * @description: 商品安全库存分页查询dto
 * @author: Bao Hongbin
 * @create: 2022-01-18 15:04
 **/
@Data
@ApiModel("商品安全库存分页查询dto")
public class ProductSecurityStockPaginationDto {
  /**
   * 租户编号
   */
  @JsonIgnore
  private String tenantCode;

  /**
   * 数据状态（删除状态）
   */
  @JsonIgnore
  private String delFlag;

  /**
   * 数据业务状态（启用状态）
   */
  @JsonIgnore
  private String enableStatus;

  /**
   * 商品编码
   */
  @ApiModelProperty("商品编码")
  private String productCode;

  /**
   * 商品名称
   */
  @ApiModelProperty("商品名称")
  private String productName;
}
