package com.biz.crm.dms.business.psi.product.sdk.dto.productstock;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 商品安全库存数量dto
 * </p>
 *
 * @author Bao Hongbin
 * @since 2022-01-07
 */
@Data
@ApiModel("商品安全库存数量vo")
public class ProductSecurityStockQuantityDto {

  /**
   * 安全库存数量
   */
  @ApiModelProperty("安全库存数量")
  private BigDecimal securityStockQuantity;

  /**
   * 是否适用所有仓库
   */
  @ApiModelProperty("是否适用所有仓库")
  private Boolean applicableToAll;

  /**
   * 排序
   */
  @ApiModelProperty("排序")
  private Integer sort;

  /**
   * 商品安全库存数量适用仓库dto
   */
  @ApiModelProperty("商品安全库存数量适用仓库dto")
  private List<ProductSecurityStockQuantityWarehouseDto> warehouseDtos;
}
