package com.biz.crm.dms.business.psi.product.sdk.dto.productstock;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * <p>
 * 商品安全库存更新dto
 * </p>
 *
 * @author Bao Hongbin
 * @since 2022-01-07
 */
@Data
@ApiModel("商品安全库存更新dto")
public class ProductSecurityStockUpdateDto {

  /**
   * id
   */
  @ApiModelProperty("id")
  private String id;

  /**
   * 备注
   */
  @ApiModelProperty("备注")
  private String remark;

  /**
   * 商品编码
   */
  @ApiModelProperty("商品编码")
  private String productCode;

  /**
   * 商品名称
   */
  @ApiModelProperty("商品名称")
  private String productName;

  /**
   * 商品安全库存数量dtos
   */
  @ApiModelProperty("商品安全库存数量dtos")
  private List<ProductSecurityStockQuantityDto> quantityDtos;
}
