package com.biz.crm.dms.business.psi.product.sdk.dto.store;
/**
 * Created by Bao Hongbin on 2022-01-18 15:05.
 */

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @program: crm-dms
 * @description: 商品入库单分页查询dto
 * @author: Bao Hongbin
 * @create: 2022-01-18 15:05
 **/
@Data
@ApiModel("商品入库单分页查询dto")
public class ProductStoredBillPaginationDto {
  /**
   * 租户编号
   */
  @JsonIgnore
  private String tenantCode;

  /**
   * 数据状态（删除状态）
   */
  @JsonIgnore
  private String delFlag;

  /**
   * 数据业务状态（启用状态）
   */
  @JsonIgnore
  private String enableStatus;

  /**
   * 关联单据类型
   */
  @ApiModelProperty("关联单据类型")
  private String relationReceivingOrderType;

  /**
   * 关联单据编码
   */
  @ApiModelProperty("关联单据编码")
  private String relationReceivingOrderCode;

  /**
   * 仓库编码
   */
  @ApiModelProperty("仓库编码")
  private String warehouseCode;

  /**
   * 仓库名称
   */
  @ApiModelProperty("仓库名称")
  private String warehouseName;

  /**
   * 商品库存操作类型
   */
  @ApiModelProperty("商品库存操作类型")
  private String productStockOperationType;

  /**
   * 类型(商品：product; 物料：material)
   */
  @ApiModelProperty("类型(商品：product; 物料：material)")
  private String type;
}
