package com.biz.crm.dms.business.psi.product.sdk.enums.productstock;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 商品库存占用操作类型
 * Created by Bao Hongbin on 2022-01-07 20:18.
 */
@Getter
@AllArgsConstructor
public enum ProductStockOccupyOperationType {
  ORDER("order","order", "下单", 1),
  ORDER_CLOSE("order_close","order_close", "订单关闭", 2),
  DELIVER("deliver","deliver", "出库", 3),
  VOID_DELIVER("void_deliver","void_deliver", "作废出库", 4);

  /**
   * key
   */
  private String key;

  /**
   * 编码
   */
  private String dictCode;

  /**
   * 说明
   */
  private String value;
  /**
   * 排序
   */
  private Integer order;


  /**
   * 根据code转枚举
   *
   * @param dictCode
   * @return
   */
  public static ProductStockOccupyOperationType codeToEnum(String dictCode) {
    ProductStockOccupyOperationType result = null;
    for (ProductStockOccupyOperationType productStockOccupyOperationType : ProductStockOccupyOperationType.values()) {
      if (productStockOccupyOperationType.dictCode.equals(dictCode)) {
        result = productStockOccupyOperationType;
      }
    }
    return result;
  }

}
