package com.biz.crm.dms.business.psi.product.sdk.enums.productstock;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 商品库存操作
 * Created by Bao Hongbin on 2022-01-07 20:18.
 */
@Getter
@AllArgsConstructor
public enum ProductStockOperation {
  STORE("store","store", "入库", 1),
  DELIVER("deliver","deliver", "出库", 2),
  FROZEN("frozen","frozen", "冻结", 3),
  THAW("thaw","thaw", "解冻", 4);

  /**
   * key
   */
  private String key;

  /**
   * 编码
   */
  private String dictCode;

  /**
   * 说明
   */
  private String value;
  /**
   * 排序
   */
  private Integer order;


  /**
   * 根据code转枚举
   *
   * @param dictCode
   * @return
   */
  public static ProductStockOperation codeToEnum(String dictCode) {
    ProductStockOperation result = null;
    for (ProductStockOperation productStockOperation : ProductStockOperation.values()) {
      if (productStockOperation.dictCode.equals(dictCode)) {
        result = productStockOperation;
      }
    }
    return result;
  }
}
