package com.biz.crm.dms.business.psi.product.sdk.enums.productstock;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 库存商品操作类型
 * Created by Bao Hongbin on 2022-01-07 20:18.
 */
@Getter
@AllArgsConstructor
public enum ProductStockOperationType {
  /**
   * 商品出入库类型
   */
  PRODUCT_STORE("product_store","product_store", "商品入库", 1),
  PRODUCT_RETURN("product_return","product_return", "商品退库", 2),
  OTHER_STORE("other_store","other_store", "其他入库", 3),
  TRANSFER_STORE("transfer_store","transfer_store", "调拨入库", 4),
  INVENTORY_SURPLUS_STORE("inventory_surplus_store","inventory_surplus_store", "盘盈入库", 5),
  SALE_DELIVER("sale_deliver","sale_deliver", "销售出库", 6),
  OTHER_DELIVER("other_deliver","other_deliver", "其他出库", 7),
  TRANSFER_DELIVER("transfer_deliver","transfer_deliver", "调拨出库", 8),
  INVENTORY_LOSS_DELIVER("inventory_loss_deliver","inventory_loss_deliver", "盘亏出库", 9),
  ORDER_CHANGE_WAREHOUSE_FREEZING("order_change_warehouse_freezing","order_change_warehouse_freezing", "订单改仓-新仓冻结", 15),
  ORDER_CHANGE_WAREHOUSE_UNFREEZE("order_change_warehouse_unfreeze","order_change_warehouse_unfreeze", "订单改仓-原仓解冻", 16),
  /**
   * 物料出入库类型
   */
  MATERIAL_STORE("material_store","material_store", "物料入库", 10),
  MATERIAL_RETURN("material_return","material_return", "物料退库入库", 11),
  MATERIAL_OTHER_STORE("material_other_store","material_other_store", "物料其他入库", 12),
  MATERIAL_ORDER_DELIVER("material_order_deliver","material_order_deliver", "物料订单出库", 13),
  MATERIAL_OTHER_DELIVER("material_other_deliver","material_other_deliver", "物料其他出库", 14);

  /**
   * key
   */
  private String key;

  /**
   * 编码
   */
  private String dictCode;

  /**
   * 说明
   */
  private String value;
  /**
   * 排序
   */
  private Integer order;

  /**
   * 根据code转枚举
   *
   * @param dictCode
   * @return
   */
  public static ProductStockOperationType codeToEnum(String dictCode) {
    ProductStockOperationType result = null;
    for (ProductStockOperationType productStockOperationType : ProductStockOperationType.values()) {
      if (productStockOperationType.dictCode.equals(dictCode)) {
        result = productStockOperationType;
      }
    }
    return result;
  }

}
