package com.biz.crm.dms.business.psi.product.sdk.enums.productstock;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 库存类型
 * Created by Bao Hongbin on 2022-01-07 20:19.
 */
@Getter
@AllArgsConstructor
public enum StockType {
  PRODUCT("product","product", "商品", 1),
  MATERIAL("material","material", "物料", 2);

  /**
   * key
   */
  private String key;

  /**
   * 编码
   */
  private String dictCode;

  /**
   * 说明
   */
  private String value;
  /**
   * 排序
   */
  private Integer order;


  /**
   * 根据code转枚举
   *
   * @param dictCode
   * @return
   */
  public static StockType codeToEnum(String dictCode) {
    StockType result = null;
    for (StockType productStockBillType : StockType.values()) {
      if (productStockBillType.dictCode.equals(dictCode)) {
        result = productStockBillType;
      }
    }
    return result;
  }

}
