package com.biz.crm.dms.business.psi.product.sdk.register.delivery;

import com.biz.crm.dms.business.psi.product.sdk.dto.productstock.DeliveryProductStockOperationDto;
import com.biz.crm.dms.business.psi.product.sdk.vo.productstock.ProductStockVo;

/**
 * 出库单商品库存注册器
 * Created by Bao Hongbin on 2022-01-13 10:14.
 */
public interface DeliveryBillProductStockRegister {
  /**
   * 单据类型（出库单）
   */
  String BILL_TYPE = "DELIVERY_BILL";

  /**
   * 获取当前注册器对应的库存操作类型
   *
   * @return
   */
  String getOperationType();

  /**
   * 执行出库库存操作
   *
   * @param operationDto
   * @return
   */
  ProductStockVo execute(DeliveryProductStockOperationDto operationDto);

  /**
   * 作废出库库存操作
   *
   * @param operationDto
   * @return
   */
  ProductStockVo rescind(DeliveryProductStockOperationDto operationDto);
}
