package com.biz.crm.dms.business.psi.product.sdk.service.productstock;

import com.biz.crm.dms.business.psi.product.sdk.dto.productstock.DeliveryStockDto;
import com.biz.crm.dms.business.psi.product.sdk.vo.productstock.DeliveryStockVo;

import com.biz.crm.dms.business.psi.product.sdk.vo.productstock.ProductStockDetailVo;
import java.util.List;

/**
 * 发货单库存接口定义
 * @Author: zengxingwang
 * @Date: 2022/3/10 14:21
 */
public interface DeliveryStockVoService {

  /**
   * 发货单查询库存信息（商品）
   * @param list
   * @return
   */
  List<DeliveryStockVo> findByDeliveryStockDto(List<DeliveryStockDto> list);

  /**
   * 发货单查询库存信息（物料）
   * @param list
   * @return
   */
  List<DeliveryStockVo> findByDeliveryMaterialStockDto(List<DeliveryStockDto> list);

  /**
   * 根据订单编码和行查询库存信息
   * @param list
   * @return
   */
  List<DeliveryStockVo> findByOrderCodeAndItemCode(List<DeliveryStockDto> list);

}
