package com.biz.crm.dms.business.psi.product.sdk.service.productstock;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.psi.product.sdk.dto.delivery.ProductDeliveryBillCreateDto;
import com.biz.crm.dms.business.psi.product.sdk.dto.delivery.ProductDeliveryBillPaginationDto;
import com.biz.crm.dms.business.psi.product.sdk.dto.delivery.ProductDeliveryBillUpdateDto;
import com.biz.crm.dms.business.psi.product.sdk.vo.delivery.ProductDeliveryBillVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * Created by Bao Hongbin on 2022-01-15 15:03.
 */
public interface ProductDeliveryBillVoService {

  /**
   * 多条件分页查询(可适用于列表分页查询和公用分页弹框)
   *
   * @param pageable
   * @param paginationDto
   * @return
   */
  Page<ProductDeliveryBillVo> findByConditions(Pageable pageable, ProductDeliveryBillPaginationDto paginationDto);

  /**
   * 按照实体中的（id）主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。
   *
   * @param id
   * @return
   */
  ProductDeliveryBillVo findDetailsById(String id);

  /**
   * 按照实体中的code进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。
   * @param code
   * @return
   */
  ProductDeliveryBillVo findDetailsByCode(String code);

  /**
   * 相关的创建过程，请注意该创建过程除了可以创建模型中的基本信息以外，还可以对模型中属于OneToMany关联的明细信息一同进行创建注意：
   * 基于模型的创建操作传入的JSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）
   *
   * @param createDto
   * @return
   */
  ProductDeliveryBillVo create(ProductDeliveryBillCreateDto createDto);

  /**
   * 相关的更新过程，请注意该更新过程只会更新在模型层被标记为了updateable的属性，
   * 包括一般属性、ManyToOne和OneToOne性质的关联属性，而ManyToMany、OneToMany的关联属性，
   * 虽然也会传入，但需要开发人员自行在Service层完善其更新过程注意：基于模型（的修改操作传入的SON对象，
   * 其主键信息必须有值，服务端将验证这个主键值是否已经存在。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）
   *
   * @param updateDto
   * @return
   */
  ProductDeliveryBillVo update(ProductDeliveryBillUpdateDto updateDto);

  /**
   * 删除
   *
   * @param ids
   */
  void deleteBatch(List<String> ids);

  /**
   * 出库
   *
   * @param ids
   */
  void handleDeliveryBatch(List<String> ids);

  /**
   * 驳回
   *
   * @param ids
   */
  void handleRejectedBatch(List<String> ids);

  /**
   * 作废
   *
   * @param ids
   */
  void handleVoidBatch(List<String> ids);


}
