package com.biz.crm.dms.business.psi.product.sdk.vo.productstock;

import com.biz.crm.business.common.sdk.vo.TenantOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 商品安全库存数量vo
 * </p>
 *
 * @author Bao Hongbin
 * @since 2022-01-07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ProductSecurityStockQuantityVo", description = "商品安全库存数量vo")
public class ProductSecurityStockQuantityVo extends TenantOpVo {


  /**
   * 安全库存id
   */
  @ApiModelProperty("安全库存id")
  private String securityStockId;

  /**
   * 安全库存数量
   */
  @ApiModelProperty("安全库存数量")
  private BigDecimal securityStockQuantity;

  /**
   * 是否适用所有仓库
   */
  @ApiModelProperty("是否适用所有仓库")
  private Boolean applicableToAll;

  /**
   * 排序
   */
  @ApiModelProperty("排序")
  private Integer sort;

  /**
   * 商品安全库存数量适用仓库vos
   */
  @ApiModelProperty("商品安全库存数量适用仓库vos")
  private List<ProductSecurityStockQuantityWarehouseVo> warehouseVos;
}
