package com.biz.crm.dms.business.psi.product.sdk.vo.store;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.biz.crm.dms.business.psi.product.sdk.enums.store.ProductStoreStatus;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 商品入库单vo
 * </p>
 *
 * @author Bao Hongbin
 * @since 2022-01-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ProductStoredBillVo", description = "商品入库单vo")
public class ProductStoredBillVo extends TenantFlagOpVo {

  /**
   * 入库单编码
   */
  @ApiModelProperty("入库单编码")
  private String storedBillCode;

  /**
   * 入库时间
   */
  @ApiModelProperty("入库时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date storedTime;

  /**
   * 经办人账号
   */
  @ApiModelProperty("经办人账号")
  private String handlerAccount;

  /**
   * 经办人姓名
   */
  @ApiModelProperty("经办人姓名")
  private String handlerName;

  /**
   * 关联收货单类型
   */
  @ApiModelProperty("关联收货单类型")
  private String relationReceivingOrderType;

  /**
   * 关联收货单编码
   */
  @ApiModelProperty("关联收货单编码")
  private String relationReceivingOrderCode;

  /**
   * 入库仓库编码
   */
  @ApiModelProperty("入库仓库编码")
  private String storeWarehouseCode;

  /**
   * 入库仓库名称
   */
  @ApiModelProperty("入库仓库名称")
  private String storeWarehouseName;

  /**
   * 出库仓库编码
   */
  @ApiModelProperty("出库仓库编码")
  private String deliveryWarehouseCode;

  /**
   * 出库仓库名称
   */
  @ApiModelProperty("出库仓库名称")
  private String deliveryWarehouseName;

  /**
   * 入库状态
   */
  @ApiModelProperty("入库状态")
  private ProductStoreStatus storedStatus;

  /**
   * 商品库存操作类型
   */
  @ApiModelProperty("商品库存操作类型")
  private String productStockOperationType;

  /**
   * 商品入库单明细vos
   */
  @ApiModelProperty("商品入库单明细vos")
  private List<ProductStoredBillDetailVo> detailVos;


}
