/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.psi.product.sdk.context.delivery;

import com.biz.crm.dms.business.psi.product.sdk.register.delivery.DeliveryBillProductStockRegister;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeliveryBillProductStockContext {
    private static final Map<String, DeliveryBillProductStockRegister> REGISTERS_CACHE = new ConcurrentHashMap<String, DeliveryBillProductStockRegister>();

    @Autowired(required=false)
    public DeliveryBillProductStockContext(List<DeliveryBillProductStockRegister> deliveryBillProductStockRegisters) {
        if (CollectionUtils.isNotEmpty(deliveryBillProductStockRegisters)) {
            for (DeliveryBillProductStockRegister deliveryBillProductStockRegister : deliveryBillProductStockRegisters) {
                REGISTERS_CACHE.put(deliveryBillProductStockRegister.getOperationType(), deliveryBillProductStockRegister);
            }
        }
    }

    public DeliveryBillProductStockRegister getRegisterByOperationType(String operationType) {
        if (StringUtils.isBlank((CharSequence)operationType)) {
            return null;
        }
        if (CollectionUtils.isEmpty(REGISTERS_CACHE.values())) {
            return null;
        }
        return REGISTERS_CACHE.get(operationType);
    }
}

