package com.biz.crm.dms.business.psi.product.sdk.context.store;
/**
 * Created by Bao Hongbin on 2022-01-13 16:59.
 */

import com.biz.crm.dms.business.psi.product.sdk.register.store.StoredBillProductStockRegister;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @program: crm-dms
 * @description: 入库单库存操作注册器上下文
 * @author: Bao Hongbin
 * @create: 2022-01-13 16:59
 **/
@Component
public class StoredBillProductStockContext {
  /**
   * 储存入库单库存操作类型和入库单库存操作注册器的映射关系
   */
  private static final Map<String, StoredBillProductStockRegister> REGISTERS_CACHE = new ConcurrentHashMap<>();

  @Autowired(required = false)
  public StoredBillProductStockContext(List<StoredBillProductStockRegister> storedBillProductStockRegisters) {
    if (CollectionUtils.isNotEmpty(storedBillProductStockRegisters)) {
      for (StoredBillProductStockRegister storedBillProductStockRegister : storedBillProductStockRegisters) {
        REGISTERS_CACHE.put(storedBillProductStockRegister.getOperationType(), storedBillProductStockRegister);
      }
    }
  }

  /**
   * 根据入库单库存操作类型获取入库单库存操作注册器
   *
   * @param operationType
   * @return 入库单库存操作注册器
   */
  public StoredBillProductStockRegister getRegisterByOperationType(String operationType) {
    if (StringUtils.isBlank(operationType)) {
      return null;
    }
    if (CollectionUtils.isEmpty(REGISTERS_CACHE.values())) {
      return null;
    }
    return REGISTERS_CACHE.get(operationType);
  }
}
