package com.biz.crm.dms.business.psi.product.sdk.dto.delivery;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * <p>
 * 商品出库单明细dto
 * </p>
 *
 * @author Bao Hongbin
 * @since 2022-01-15
 */
@Data
@ApiModel("商品出库单明细dto")
public class ProductDeliveryBillDetailDto{

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String customerCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  private String customerName;

  /**
   * 地址
   */
  @ApiModelProperty("地址")
  private String address;

  /**
   * 原始订单编号
   */
  @ApiModelProperty("原始订单编号")
  private String originalOrderCode;

  /**
   * 订单类型
   */
  @ApiModelProperty("订单类型")
  private String orderType;

  /**
   * 订单编码
   */
  @ApiModelProperty("订单编码")
  private String orderCode;


  /**
   * 订单行编码
   */
  @ApiModelProperty("订单行编码")
  private String orderItemCode;

  /**
   * 行项目类型
   */
  @ApiModelProperty("行项目类型")
  private String itemType;

  /**
   * 商品编码
   */
  @ApiModelProperty("商品编码")
  private String productCode;

  /**
   * 商品名称
   */
  @ApiModelProperty("商品名称")
  private String productName;

  /**
   * 商品规格
   */
  @ApiModelProperty("商品规格")
  private String productSpec;

  /**
   * 商品单位
   */
  @ApiModelProperty("商品单位")
  private String productUnit;

  /**
   * 发货单行项编码
   */
  @ApiModelProperty("发货单行项编码")
  private String shipmentItemCode;

  /**
   * 发货单行项总数
   */
  @ApiModelProperty("发货单行项总数")
  private BigDecimal shipmentItemQuantity;

  /**
   * 发货总数量数
   */
  @ApiModelProperty("发货总数量数")
  private BigDecimal deliveryQuantity;

  /**
   * 本次发货数量
   */
  @ApiModelProperty("本次发货数量")
  private BigDecimal currentQuantity;

  /**
   * 已出库数量
   */
  @ApiModelProperty("已出库数量")
  private BigDecimal deliveryOutQuantity;

  /**
   * 待出库数量
   */
  @ApiModelProperty("待出库数量")
  private BigDecimal deliveryingQuantity;

  /**
   * 可用库存
   */
  @ApiModelProperty("可用库存")
  private BigDecimal availableStock;

  /**
   * 出库仓库编码
   */
  @ApiModelProperty("出库仓库编码")
  private String deliveryWarehouseCode;

  /**
   * 出库仓库名称
   */
  @ApiModelProperty("出库仓库名称")
  private String deliveryWarehouseName;
}
