package com.biz.crm.dms.business.psi.product.sdk.dto.productstock;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import lombok.Data;

/**
 * <p>
 * 商品库存明细分页查询dto
 * </p>
 *
 * @author Bao Hongbin
 * @since 2022-01-07
 */
@Data
@ApiModel("商品库存明细分页查询dto")
public class ProductStockDetailPaginationDto {

  /**
   * 租户编号
   */
  @JsonIgnore
  private String tenantCode;

  /**
   * 数据状态（删除状态）
   */
  @JsonIgnore
  private String delFlag;

  /**
   * 数据业务状态（启用状态）
   */
  @JsonIgnore
  private String enableStatus;

  /**
   * 库存id
   */
  @ApiModelProperty("库存id")
  private String stockId;

  /**
   * 仓库编码
   */
  @ApiModelProperty("仓库编码")
  private String warehouseCode;

  /**
   * 仓库名称
   */
  @ApiModelProperty("仓库名称")
  private String warehouseName;

  /**
   * 商品编码
   */
  @ApiModelProperty("商品编码")
  private String productCode;

  /**
   * 商品名称
   */
  @ApiModelProperty("商品名称")
  private String productName;

  /**
   * 关联商品库存单据类型
   */
  @ApiModelProperty("关联商品库存单据类型")
  private String billType;

  /**
   * 订单编码
   */
  @ApiModelProperty("订单编码")
  private String orderCode;

  /**
   * 订单行编码
   */
  @ApiModelProperty("订单行编码")
  private String orderItemCode;


  /**
   * 订单编码+订单行编码 集合
   */
  @ApiModelProperty("订单行编码")
  private List<String> orderCodeAddItems;

}
