package com.biz.crm.dms.business.psi.product.sdk.dto.productstock;
/**
 * Created by Bao Hongbin on 2022-01-18 15:05.
 */

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Set;
import lombok.Data;

import java.util.List;

/**
 * @program: crm-dms
 * @description: 商品库存分页查询dto
 * @author: Bao Hongbin
 * @create: 2022-01-18 15:05
 **/
@Data
@ApiModel("商品库存分页查询dto")
public class ProductStockPaginationDto {
  /**
   * 租户编号
   */
  @JsonIgnore
  private String tenantCode;

  /**
   * 数据状态（删除状态）
   */
  @JsonIgnore
  private String delFlag;

  /**
   * 数据业务状态（启用状态）
   */
  @JsonIgnore
  private String enableStatus;

  /**
   * 商品层级编码
   */
  @ApiModelProperty("商品层级编码")
  private String productLevelCode;

  /**
   * 商品层级编码集合
   */
  @ApiModelProperty("商品层级编码集合")
  private List<String> productLevelCodes;

  /**
   * 商品层级名称
   */
  @ApiModelProperty("商品层级名称")
  private String productLevelName;

  /**
   * 商品编码
   */
  @ApiModelProperty("商品编码")
  private String productCode;

  /**
   * 商品名称
   */
  @ApiModelProperty("商品名称")
  private String productName;

  /**
   * 仓库编码
   */
  @ApiModelProperty("仓库编码")
  private String warehouseCode;

  /**
   * 仓库名称
   */
  @ApiModelProperty("仓库名称")
  private String warehouseName;

  /**
   * 是否低于安全库存
   */
  @ApiModelProperty("是否低于安全库存")
  private Boolean ltSecurityStock;

  /**
   * 类型(商品：product; 物料：material)
   */
  @ApiModelProperty("类型(商品：product; 物料：material)")
  private String type;

  /**
   * 商品编码集合
   */
  @ApiModelProperty("商品编码集合")
  private Set<String> productCodeSet;
}
