package com.biz.crm.dms.business.psi.product.sdk.enums.delivery;

import com.biz.crm.dms.business.psi.product.sdk.enums.productstock.ProductStockOperation;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * Created by Bao Hongbin on 2022-01-15 11:13.
 */
@Getter
@AllArgsConstructor
public enum ProductDeliveryStatus {
  WAIT_DELIVERY("wait_delivery","wait_delivery", "待出库", 1),
  DELIVERED("delivered","delivered", "已出库", 2),
  VOIDED("voided","voided", "已作废", 3),
  REJECTED("rejected","rejected", "已驳回", 4);

  /**
   * key
   */
  private String key;

  /**
   * 编码
   */
  private String dictCode;

  /**
   * 说明
   */
  private String value;
  /**
   * 排序
   */
  private Integer order;


  /**
   * 根据code转枚举
   *
   * @param dictCode
   * @return
   */
  public static ProductDeliveryStatus codeToEnum(String dictCode) {
    ProductDeliveryStatus result = null;
    for (ProductDeliveryStatus productDeliveryStatus : ProductDeliveryStatus.values()) {
      if (productDeliveryStatus.dictCode.equals(dictCode)) {
        result = productDeliveryStatus;
      }
    }
    return result;
  }
}
