package com.biz.crm.dms.business.psi.product.sdk.enums.productstock;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 关联单据类型
 * Created by Bao Hongbin on 2022-01-07 20:18.
 */
@Getter
@AllArgsConstructor
public enum AssociatedDocumentsType {

  /**
   * 物料入库关联类型
   */
  MATERIAL_STORE_RETURN("material_store_return","material_store_return", "退货单", 1),
  MATERIAL_STORE_PURCHASE("material_store_purchase","material_store_purchase", "采购订单", 2),
  MATERIAL_STORE_OTHER("material_store_other","material_store_other", "其他", 3),
  /**
   * 物料出库关联类型
   */
  MATERIAL_DELIVER_INVOICE("material_deliver_invoice","material_deliver_invoice", "促销物料发货单", 4),
  MATERIAL_DELIVER_OTHER("material_deliver_other","material_deliver_other", "其他出库单", 5),

  /**
   * 商品出库关联类型
   */
  SALE("sale","sale", "销售订单", 6),
  OTHER("other","other", "其他出库单", 7),
  INVENTORY("inventory","inventory", "盘点单", 8),
  TRANSFER("transfer","transfer", "调拨", 9),
  DELIVER("deliver","deliver", "发货单", 10),

  /**
   * 商品入库关联类型
   */
  ASSOCIATE_STORE_RETURN("associate_store_return","associate_store_return", "退货单", 11),
  ASSOCIATE_STORE_PURCHASE("associate_store_purchase","associate_store_purchase", "采购订单", 12),
  ASSOCIATE_STORE_OTHER("associate_store_other","associate_store_other", "其他", 13),
  ASSOCIATE_STORE_INVENTORY("associate_store_inventory","associate_store_inventory", "盘点单", 14),
  ASSOCIATE_STORE_TRANSFER("associate_store_transfer","associate_store_transfer", "调拨单", 15);
  /**
   * key
   */
  private String key;

  /**
   * 编码
   */
  private String dictCode;

  /**
   * 说明
   */
  private String value;
  /**
   * 排序
   */
  private Integer order;

  /**
   * 根据code转枚举
   *
   * @param dictCode
   * @return
   */
  public static AssociatedDocumentsType codeToEnum(String dictCode) {
    AssociatedDocumentsType result = null;
    for (AssociatedDocumentsType productStockOperationType : AssociatedDocumentsType.values()) {
      if (productStockOperationType.dictCode.equals(dictCode)) {
        result = productStockOperationType;
      }
    }
    return result;
  }

}
