package com.biz.crm.dms.business.psi.product.sdk.enums.productstock;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 商品库存单据类型
 * Created by Bao Hongbin on 2022-01-07 20:19.
 */
@Getter
@AllArgsConstructor
public enum ProductStockBillType {
  STORED_ORDER("stored_order","stored_order", "入库单", 1),
  DELIVERY_ORDER("delivery_order","delivery_order", "出库单", 2);

  /**
   * key
   */
  private String key;

  /**
   * 编码
   */
  private String dictCode;

  /**
   * 说明
   */
  private String value;
  /**
   * 排序
   */
  private Integer order;


  /**
   * 根据code转枚举
   *
   * @param dictCode
   * @return
   */
  public static ProductStockBillType codeToEnum(String dictCode) {
    ProductStockBillType result = null;
    for (ProductStockBillType productStockBillType : ProductStockBillType.values()) {
      if (productStockBillType.dictCode.equals(dictCode)) {
        result = productStockBillType;
      }
    }
    return result;
  }

}
