package com.biz.crm.dms.business.psi.product.sdk.enums.store;

import com.biz.crm.dms.business.psi.product.sdk.enums.productstock.ProductStockOperation;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * Created by Bao Hongbin on 2022-01-15 11:13.
 */
@Getter
@AllArgsConstructor
public enum ProductStoreStatus {
  WAIT_STORE("wait_store","wait_store", "待入库", 1),
  STORED("stored","stored", "已入库", 2),
  VOIDED("voided","voided", "已作废", 3),
  REJECTED("rejected","rejected", "已驳回", 4);

  /**
   * key
   */
  private String key;

  /**
   * 编码
   */
  private String dictCode;

  /**
   * 说明
   */
  private String value;
  /**
   * 排序
   */
  private Integer order;


  /**
   * 根据code转枚举
   *
   * @param dictCode
   * @return
   */
  public static ProductStoreStatus codeToEnum(String dictCode) {
    ProductStoreStatus result = null;
    for (ProductStoreStatus productStoreStatus : ProductStoreStatus.values()) {
      if (productStoreStatus.dictCode.equals(dictCode)) {
        result = productStoreStatus;
      }
    }
    return result;
  }
}
