package com.biz.crm.dms.business.psi.product.sdk.register.store;

import com.biz.crm.dms.business.psi.product.sdk.dto.productstock.StoredProductStockOperationDto;
import com.biz.crm.dms.business.psi.product.sdk.vo.productstock.ProductStockVo;

/**
 * 入库单商品库存注册器
 * Created by Bao Hongbin on 2022-01-13 10:14.
 */
public interface StoredBillProductStockRegister {
  /**
   * 单据类型（入库单）
   */
  String BILL_TYPE = "STORED_BILL";

  /**
   * 获取当前注册器对应的库存操作类型
   *
   * @return
   */
  String getOperationType();

  /**
   * 执行入库库存操作
   *
   * @param operationDto
   * @return
   */
  ProductStockVo execute(StoredProductStockOperationDto operationDto);

  /**
   * 作废入库库存操作
   *
   * @param operationDto
   * @return
   */
  ProductStockVo rescind(StoredProductStockOperationDto operationDto);
}
